/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddFactory;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import java.util.List;
import owl.bdd.BddSetFactory;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.FactorySupplier;
import owl.bdd.jbdd.JBddEquivalenceClassFactory;
import owl.bdd.jbdd.JBddSetFactory;

public enum JBddSupplier implements FactorySupplier
{
    JBDD_SUPPLIER_INSTANCE;


    static Bdd create(int size) {
        ImmutableBddConfiguration configuration = ImmutableBddConfiguration.builder().logStatisticsOnShutdown(false).useGlobalComposeCache(false).integrityDuplicatesMaximalSize(50).cacheBinaryDivider(4).cacheTernaryDivider(4).growthFactor(2.0).build();
        return BddFactory.buildBddRecursive((int)size, (BddConfiguration)configuration);
    }

    @Override
    public EquivalenceClassFactory getEquivalenceClassFactory(List<String> atomicPropositions, EquivalenceClassFactory.Encoding defaultEncoding) {
        Bdd eqFactoryBdd = JBddSupplier.create(1024 * (atomicPropositions.size() + 1));
        return new JBddEquivalenceClassFactory(eqFactoryBdd, atomicPropositions, defaultEncoding);
    }

    @Override
    public BddSetFactory getBddSetFactory() {
        return new JBddSetFactory(JBddSupplier.create(1024));
    }
}

