/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.List;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import owl.cinterface.CAutomaton;
import owl.cinterface.UnmanagedMemory;
import owl.util.OwlVersion;

@CContext(value=CDirectives.class)
public final class CInterface {
    public static final String CALL_DESTROY = "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer.";
    public static final String CHAR_TO_STRING = "Decodes a 0 terminated C char* to a Java string using the platform's default charset.";
    public static final int SEPARATOR = -232323;
    public static final int FEATURE_SEPARATOR = -424242;

    private CInterface() {
    }

    @CEntryPoint(name="destroy_object_handle", exceptionHandler=PrintStackTraceAndExit.ReturnVoid.class)
    public static void destroyObjectHandle(IsolateThread thread, ObjectHandle handle) {
        ObjectHandles.getGlobal().destroy(handle);
    }

    @CEntryPoint(name="free_unmanaged_memory", exceptionHandler=PrintStackTraceAndExit.ReturnVoid.class)
    public static void freeUnmanagedMemory(IsolateThread thread, PointerBase ptr) {
        UnmanagedMemory.free(ptr);
    }

    @CEntryPoint(name="print_object_handle", exceptionHandler=PrintStackTraceAndExit.ReturnUnsignedWord.class)
    public static UnsignedWord printObjectHandle(IsolateThread thread, ObjectHandle handle, CCharPointer buffer, UnsignedWord bufferSize) {
        return CTypeConversion.toCString((CharSequence)ObjectHandles.getGlobal().get(handle).toString(), (CCharPointer)buffer, (UnsignedWord)bufferSize);
    }

    @CEntryPoint(name="owl_version", exceptionHandler=PrintStackTraceAndExit.ReturnUnsignedWord.class)
    public static UnsignedWord owlVersion(IsolateThread thread, CCharPointer buffer, UnsignedWord bufferSize) {
        return CTypeConversion.toCString((CharSequence)OwlVersion.getNameAndVersion().version(), (CCharPointer)buffer, (UnsignedWord)bufferSize);
    }

    @CConstant(value="OWL_INITIAL_STATE")
    public static native int owlInitialState();

    @CConstant(value="OWL_ACCEPTING_SINK")
    public static native int owlAcceptingSink();

    @CConstant(value="OWL_REJECTING_SINK")
    public static native int owlRejectingSink();

    @CConstant(value="OWL_SEPARATOR")
    public static native int owlSeparator();

    @CConstant(value="OWL_FEATURE_SEPARATOR")
    public static native int owlFeatureSeparator();

    public static void main(String ... args) {
    }

    static final class PrintStackTraceAndExit {
        private PrintStackTraceAndExit() {
        }

        static void handleException(Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.err.flush();
            System.exit(-1);
        }

        static final class ReturnVoid {
            private ReturnVoid() {
            }

            static void handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
            }
        }

        static final class ReturnAcceptance {
            private ReturnAcceptance() {
            }

            static CAutomaton.Acceptance handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return CAutomaton.Acceptance.BUCHI;
            }
        }

        static final class ReturnInt {
            private ReturnInt() {
            }

            static int handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return Integer.MIN_VALUE;
            }
        }

        static final class ReturnBoolean {
            private ReturnBoolean() {
            }

            static boolean handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return false;
            }
        }

        static final class ReturnUnsignedWord {
            private ReturnUnsignedWord() {
            }

            static UnsignedWord handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return WordFactory.unsigned((long)Long.MIN_VALUE);
            }
        }

        static final class ReturnObjectHandle {
            private ReturnObjectHandle() {
            }

            static ObjectHandle handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return ObjectHandles.getGlobal().create(null);
            }
        }
    }

    public static class CDirectives
    implements CContext.Directives {
        public List<String> getHeaderFiles() {
            String headerLocation = System.getProperty("owlHeader");
            if (headerLocation == null) {
                throw new IllegalArgumentException("Location of header file is missing.Use -DowlHeader=/foo/bar/ to define location.");
            }
            return List.of(String.format("\"%s/owltypes.h\"", headerLocation));
        }
    }
}

