/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import owl.cinterface.CInterface;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragment;
import owl.ltl.parser.LtlParser;
import owl.ltl.parser.LtlfParser;
import owl.ltl.rewriter.PushNextThroughPropositionalVisitor;
import owl.ltl.rewriter.SimplifierRepository;
import owl.ltl.visitors.Converter;

@CContext(value=CInterface.CDirectives.class)
public final class CLabelledFormula {
    private static final String NAMESPACE = "ltl_formula_";
    private static final int MAX_ITERATIONS = 10;

    private CLabelledFormula() {
    }

    @CEntryPoint(name="ltl_formula_parse", documentation={"Parse the given string with the given atomic propositions and return an LTL formula.", "Decodes a 0 terminated C char* to a Java string using the platform's default charset.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle parse(IsolateThread thread, CCharPointer cFormulaString, CCharPointerPointer cAtomicPropositions, int cAtomicPropositionsLength) {
        LabelledFormula labelledFormula = LtlParser.parse(CTypeConversion.toJavaString((CCharPointer)cFormulaString), CLabelledFormula.atomicPropositions(cAtomicPropositions, cAtomicPropositionsLength));
        return ObjectHandles.getGlobal().create((Object)labelledFormula);
    }

    @CEntryPoint(name="ltl_formula_parse_with_finite_semantics", documentation={"Parse the given string with the given atomic propositions and return an LTL formula with finite semantics.", "Decodes a 0 terminated C char* to a Java string using the platform's default charset.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle create(IsolateThread thread, CCharPointer cFormulaString, CCharPointerPointer cAtomicPropositions, int cAtomicPropositionsLength) {
        LabelledFormula labelledFormula = LtlfParser.parseAndTranslateToLtl(CTypeConversion.toJavaString((CCharPointer)cFormulaString), CLabelledFormula.atomicPropositions(cAtomicPropositions, cAtomicPropositionsLength));
        return ObjectHandles.getGlobal().create((Object)labelledFormula);
    }

    private static List<String> atomicPropositions(CCharPointerPointer pointer, int length) {
        List<String> atomicPropositions = Arrays.asList(new String[length]);
        for (int i = 0; i < length; ++i) {
            CCharPointer cAtomicProposition = pointer.read(i);
            atomicPropositions.set(i, CTypeConversion.toJavaString((CCharPointer)cAtomicProposition));
        }
        return atomicPropositions;
    }

    @CEntryPoint(name="ltl_formula_simplify", documentation={"Simplify the given LTL formula assuming a Game-semantics where atomic propositions less ", "than `firstOutputAtomicProposition` is controlled by the environment trying to dissatisfy ", "the formula and atomic proposition greater or equal are controlled by the system. The ", "status of atomic proposition is written to the passed int pointer using the encoding ", "provided by `atomic_proposition_status_t`", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle simplify(IsolateThread thread, ObjectHandle cLabelledFormula, int firstOutputAtomicProposition, CIntPointer cAtomicPropositionStatuses, int cAtomicPropositionsStatusesLength) {
        return ObjectHandles.getGlobal().create((Object)CLabelledFormula.simplify((LabelledFormula)ObjectHandles.getGlobal().get(cLabelledFormula), firstOutputAtomicProposition, cAtomicPropositionStatuses, cAtomicPropositionsStatusesLength));
    }

    static LabelledFormula simplify(LabelledFormula labelledFormula, int firstOutputAtomicProposition, CIntPointer cAtomicPropositionStatuses, int cAtomicPropositionsStatusesLength) {
        Formula oldFormula;
        Formula processedFormula;
        int atomicPropositions = labelledFormula.atomicPropositions().size();
        AtomicPropositionStatus[] atomicPropositionStatuses = new AtomicPropositionStatus[atomicPropositions];
        Arrays.fill((Object[])atomicPropositionStatuses, (Object)AtomicPropositionStatus.UNUSED);
        Formula newFormula = processedFormula = PushNextThroughPropositionalVisitor.apply(labelledFormula).formula().substitute(Formula::nnf);
        int iterations = 0;
        do {
            oldFormula = newFormula;
            PolaritySimplifier polaritySimplifier = new PolaritySimplifier(oldFormula, atomicPropositionStatuses, firstOutputAtomicProposition);
            newFormula = SimplifierRepository.SYNTACTIC_FIXPOINT.apply(oldFormula.accept(polaritySimplifier));
        } while (++iterations < 10 && !oldFormula.equals(newFormula));
        processedFormula = newFormula;
        processedFormula.atomicPropositions(true).stream().forEach(atomicProposition -> {
            assert (atomicPropositionStatuses[atomicProposition] == AtomicPropositionStatus.UNUSED);
            atomicPropositionStatuses[atomicProposition] = AtomicPropositionStatus.USED;
        });
        for (int i = 0; i < cAtomicPropositionsStatusesLength; ++i) {
            AtomicPropositionStatus status = i < atomicPropositions ? atomicPropositionStatuses[i] : AtomicPropositionStatus.UNUSED;
            cAtomicPropositionStatuses.write(i, ImageInfo.inImageCode() ? status.getCValue() : status.ordinal());
        }
        return labelledFormula.wrap(processedFormula);
    }

    private static class PolaritySimplifier
    extends Converter {
        private final AtomicPropositionStatus[] atomicPropositionStatuses;
        private final Set<Literal> singlePolarityInputVariables;
        private final Set<Literal> singlePolarityOutputVariables;

        private PolaritySimplifier(Formula formula, AtomicPropositionStatus[] atomicPropositionStatuses, int firstOutputVariable) {
            super(SyntacticFragment.ALL);
            this.atomicPropositionStatuses = atomicPropositionStatuses;
            Set<Literal> atoms = formula.nnf().subformulas(Literal.class);
            this.singlePolarityInputVariables = atoms.stream().filter(x -> x.getAtom() < firstOutputVariable && !atoms.contains(x.not())).collect(Collectors.toSet());
            this.singlePolarityOutputVariables = atoms.stream().filter(x -> firstOutputVariable <= x.getAtom() && !atoms.contains(x.not())).collect(Collectors.toSet());
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.singlePolarityInputVariables.contains(literal)) {
                AtomicPropositionStatus constant;
                AtomicPropositionStatus atomicPropositionStatus = constant = literal.isNegated() ? AtomicPropositionStatus.CONSTANT_TRUE : AtomicPropositionStatus.CONSTANT_FALSE;
                assert (this.atomicPropositionStatuses[literal.getAtom()] == AtomicPropositionStatus.UNUSED || this.atomicPropositionStatuses[literal.getAtom()] == constant);
                this.atomicPropositionStatuses[literal.getAtom()] = constant;
                return BooleanConstant.FALSE;
            }
            if (this.singlePolarityOutputVariables.contains(literal)) {
                AtomicPropositionStatus constant;
                AtomicPropositionStatus atomicPropositionStatus = constant = literal.isNegated() ? AtomicPropositionStatus.CONSTANT_FALSE : AtomicPropositionStatus.CONSTANT_TRUE;
                assert (this.atomicPropositionStatuses[literal.getAtom()] == AtomicPropositionStatus.UNUSED || this.atomicPropositionStatuses[literal.getAtom()] == constant);
                this.atomicPropositionStatuses[literal.getAtom()] = constant;
                return BooleanConstant.TRUE;
            }
            assert (this.atomicPropositionStatuses[literal.getAtom()] == AtomicPropositionStatus.UNUSED);
            return literal;
        }

        @Override
        public Formula visit(Biconditional biconditional) {
            assert (Collections.disjoint(biconditional.subformulas(Literal.class), Sets.union(this.singlePolarityInputVariables, this.singlePolarityOutputVariables)));
            return biconditional;
        }
    }

    @CEnum(value="atomic_proposition_status_t")
    public static enum AtomicPropositionStatus {
        CONSTANT_TRUE,
        CONSTANT_FALSE,
        USED,
        UNUSED;


        @CEnumValue
        public native int getCValue();

        @CEnumLookup
        public static native AtomicPropositionStatus fromCValue(int var0);
    }
}

