/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.auto.value.AutoValue;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.game.AutoValue_GameFactory_ImmutableGame_ValueEdge;
import owl.game.Game;

public final class GameFactory {
    private GameFactory() {
    }

    public static <S, A extends EmersonLeiAcceptance> Game<S, A> copyOf(Game<S, A> game) {
        assert (game.is(Automaton.Property.COMPLETE)) : "Only defined for complete game.";
        return new ImmutableGame<S, A>(game);
    }

    static final class ImmutableGame<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeMapImplementation<S, A>
    implements Game<S, A> {
        private final ImmutableValueGraph<S, ValueEdge> graph;
        private final Set<S> player1Nodes;
        private final List<String> variablesPlayer1;
        private final List<String> variablesPlayer2;
        private final BiFunction<S, Game.Owner, BitSet> choice;

        ImmutableGame(Game<S, A> game) {
            super(game.atomicPropositions(), game.factory(), game.initialStates(), game.acceptance());
            HashSet player1NodesBuilder = new HashSet();
            MutableValueGraph graph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
            for (Object state : game.states()) {
                if (Game.Owner.PLAYER_1 == game.owner(state)) {
                    player1NodesBuilder.add(state);
                }
                game.edgeMap(state).forEach((edge, valuations) -> graph.putEdgeValue(state, edge.successor(), (Object)new AutoValue_GameFactory_ImmutableGame_ValueEdge(edge.colours().first().orElse(Integer.MAX_VALUE), (BddSet)valuations)));
            }
            this.graph = ImmutableValueGraph.copyOf((ValueGraph)graph);
            this.player1Nodes = Set.copyOf(player1NodesBuilder);
            this.variablesPlayer1 = List.copyOf(game.variables(Game.Owner.PLAYER_1));
            this.variablesPlayer2 = List.copyOf(game.variables(Game.Owner.PLAYER_2));
            this.choice = game::choice;
        }

        @Override
        public BitSet choice(S state, Game.Owner owner) {
            return this.choice.apply(state, owner);
        }

        @Override
        protected Map<Edge<S>, BddSet> edgeMapImpl(S state) {
            HashMap<Edge<S>, BddSet> labelledEdges = new HashMap<Edge<S>, BddSet>();
            this.graph.edges().stream().filter(x -> x.source().equals(state)).forEach(x -> {
                ValueEdge valueEdge = (ValueEdge)this.graph.edgeValue(x.source(), x.target()).get();
                Edge<Object> edge = valueEdge.colour() == -1 ? Edge.of(x.target()) : Edge.of(x.target(), valueEdge.colour());
                labelledEdges.merge(edge, valueEdge.valuationSet(), BddSet::union);
            });
            return labelledEdges;
        }

        @Override
        public Game.Owner owner(S state) {
            return this.player1Nodes.contains(state) ? Game.Owner.PLAYER_1 : Game.Owner.PLAYER_2;
        }

        @Override
        public Set<S> predecessors(S successor) {
            return this.graph.predecessors(successor);
        }

        @Override
        public List<String> variables(Game.Owner owner) {
            return owner == Game.Owner.PLAYER_1 ? this.variablesPlayer1 : this.variablesPlayer2;
        }

        @AutoValue
        static abstract class ValueEdge {
            ValueEdge() {
            }

            abstract int colour();

            abstract BddSet valuationSet();
        }
    }
}

