/*
 * Decompiled with CFR 0.152.
 */
package owl.game.algorithms;

import com.google.auto.value.AutoValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.game.Game;
import owl.game.GameViews;
import owl.game.algorithms.AutoValue_OinkGameSolver_PriorityState;
import owl.game.algorithms.ParityGameSolver;

public final class OinkGameSolver
implements ParityGameSolver {
    private static final Logger logger = Logger.getLogger(OinkGameSolver.class.getName());
    private static final String OINK_EXECUTABLE_NAME = "oink";

    public static boolean checkOinkExecutable() {
        return Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).anyMatch(path -> Files.exists(path.resolve(OINK_EXECUTABLE_NAME), new LinkOption[0]) && Files.isExecutable(path.resolve(OINK_EXECUTABLE_NAME)));
    }

    public static <S> Map<Integer, S> toOinkInstance(Game<S, ? extends ParityAcceptance> game, PrintWriter writer) {
        HashMap<PriorityState, Integer> oinkNumbering = new HashMap<PriorityState, Integer>();
        HashMap<Integer, Object> reverseMapping = new HashMap<Integer, Object>();
        if (game.initialStates().size() != 1) {
            throw new IllegalArgumentException("Game must have exactly one initial state.");
        }
        Object initialState = game.initialState();
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        if (acceptance.parity() != ParityAcceptance.Parity.MAX_EVEN) {
            throw new IllegalArgumentException("Game acceptance must be of type MAX_EVEN.");
        }
        oinkNumbering.put(PriorityState.of(initialState, 0), 0);
        reverseMapping.put(0, initialState);
        HashSet reached = new HashSet(List.of(initialState));
        ArrayDeque queue = new ArrayDeque(reached);
        while (!queue.isEmpty()) {
            Object state = queue.poll();
            Set edges = game.edges(state);
            if (edges.isEmpty()) {
                throw new IllegalArgumentException("Game must not have dead ends.");
            }
            for (Edge edge : edges) {
                Object successor = edge.successor();
                int statePriority = edge.colours().last().orElse(-1);
                PriorityState oinkSuccessor = PriorityState.of(successor, statePriority);
                int id2 = oinkNumbering.size();
                oinkNumbering.putIfAbsent(oinkSuccessor, id2);
                reverseMapping.put(id2, successor);
                if (!reached.add(successor)) continue;
                queue.add(successor);
            }
        }
        writer.print("parity ");
        writer.print(oinkNumbering.size());
        writer.println(";");
        oinkNumbering.forEach((pair, id) -> {
            writer.print(id);
            writer.print(' ');
            writer.print(pair.priority());
            writer.print(' ');
            writer.print(game.owner(pair.state()).isEven() ? 0 : 1);
            Iterator it = game.edges(pair.state()).iterator();
            if (it.hasNext()) {
                writer.print(' ');
            }
            boolean first = true;
            BitSet printed = new BitSet();
            while (it.hasNext()) {
                int statePriority;
                Edge edge = it.next();
                Object successor = edge.successor();
                int successorIndex = (Integer)oinkNumbering.get(PriorityState.of(successor, statePriority = edge.colours().last().orElse(-1)));
                if (printed.get(successorIndex)) {
                    if (successorIndex < 0) {
                        throw new OinkExecutionException("Illegal successor index.");
                    }
                    if (!first) {
                        writer.print(',');
                    }
                    first = false;
                    writer.print(successorIndex);
                }
                printed.set(successorIndex);
            }
            writer.print(" \"");
            writer.print(pair.state());
            writer.print(" (");
            writer.print(pair.priority());
            writer.print(")\"");
            writer.println(';');
        });
        writer.flush();
        return reverseMapping;
    }

    @Override
    public <S> boolean realizable(Game<S, ? extends ParityAcceptance> game) {
        if (((ParityAcceptance)game.acceptance()).parity() != ParityAcceptance.Parity.MAX_EVEN) {
            throw new IllegalArgumentException("Input game must be of type MAX_EVEN.");
        }
        return this.solve(GameViews.replaceInitialStates(game, game.states())).player2.contains(game.initialState());
    }

    @Override
    public <S> ParityGameSolver.WinningRegions<S> solve(Game<S, ? extends ParityAcceptance> game) {
        if (((ParityAcceptance)game.acceptance()).parity() != ParityAcceptance.Parity.MAX_EVEN) {
            throw new IllegalArgumentException("Input game must be of type MAX_EVEN.");
        }
        if (!OinkGameSolver.checkOinkExecutable()) {
            throw new OinkExecutionException("Could not find oink executable.");
        }
        if (!game.is(Automaton.Property.COMPLETE)) {
            logger.severe("Game with initial state " + game.initialState() + "is incomplete");
            throw new IllegalArgumentException("input game must be complete");
        }
        StringWriter gameRepresentationWriter = new StringWriter();
        PrintWriter represantationWriter = new PrintWriter(gameRepresentationWriter);
        Map<Integer, S> mapping = OinkGameSolver.toOinkInstance(game, represantationWriter);
        ProcessBuilder oinkProcessBuilder = new ProcessBuilder(OINK_EXECUTABLE_NAME, "-o", "/dev/stdout");
        Process oinkProcess = null;
        try {
            oinkProcess = oinkProcessBuilder.start();
        }
        catch (IOException e) {
            logger.severe("could not start oink process");
            throw new OinkExecutionException("Oink process could not be started.", e);
        }
        BufferedWriter oinkWriter = new BufferedWriter(new OutputStreamWriter(oinkProcess.getOutputStream()));
        BufferedReader oinkReader = new BufferedReader(new InputStreamReader(oinkProcess.getInputStream()));
        InputStream oinkErrorReader = oinkProcess.getErrorStream();
        String representation = gameRepresentationWriter.toString();
        representation.lines().forEach(str -> {
            try {
                oinkWriter.write((String)str);
            }
            catch (IOException e) {
                logger.severe("error piping game data to oink process");
                throw new OinkExecutionException("Could not pipe data to oink process.", e);
            }
        });
        try {
            if (oinkErrorReader.available() > 0) {
                for (int i = 0; i < oinkErrorReader.available(); ++i) {
                    logger.severe("oink reported " + oinkErrorReader.read());
                }
                throw new OinkExecutionException("Oink reported an error.");
            }
        }
        catch (IOException e) {
            logger.severe("could not even read standard error of oink process");
            throw new OinkExecutionException("Reading from oink stderr failed.", e);
        }
        try {
            oinkWriter.close();
        }
        catch (IOException e) {
            logger.severe("error closing pipe to oink process");
            throw new OinkExecutionException("Pipe to oink process could not be closed", e);
        }
        try {
            ParityGameSolver.WinningRegions<S> winningRegions = this.parseSolution(oinkReader, mapping);
            oinkReader.close();
            return winningRegions;
        }
        catch (IOException e) {
            logger.severe("could not read output from oink process");
            throw new OinkExecutionException("Reading from oink stdout failed.", e);
        }
    }

    private <S> ParityGameSolver.WinningRegions<S> parseSolution(BufferedReader solution, Map<Integer, S> mapping) throws IOException {
        solution.readLine();
        String currentLine = solution.readLine();
        if (null == currentLine) {
            throw new OinkExecutionException("Received empty solution.");
        }
        HashSet<S> evenRegion = new HashSet<S>();
        while (currentLine != null) {
            if (currentLine.contains("[")) {
                currentLine = solution.readLine();
                continue;
            }
            String[] elements = currentLine.replaceFirst(";$", "").split(" ");
            if (elements.length < 2) {
                throw new OinkExecutionException("Got solution line with too few elements.");
            }
            int node = Integer.parseInt(elements[0]);
            int winner = Integer.parseInt(elements[1]);
            if (0 == winner) {
                if (!mapping.containsKey(node)) {
                    throw new OinkExecutionException("Illegal node in solution.");
                }
                evenRegion.add(mapping.get(node));
            }
            currentLine = solution.readLine();
        }
        return ParityGameSolver.WinningRegions.of(evenRegion, Game.Owner.PLAYER_2);
    }

    @AutoValue
    static abstract class PriorityState<S>
    implements AnnotatedState<S> {
        PriorityState() {
        }

        static <S> PriorityState<S> of(S state, int priority) {
            return new AutoValue_OinkGameSolver_PriorityState<S>(state, priority);
        }

        @Override
        public abstract S state();

        abstract int priority();
    }

    public static class OinkExecutionException
    extends RuntimeException {
        public OinkExecutionException(String message) {
            super(message);
        }

        public OinkExecutionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

