/*
 * Decompiled with CFR 0.152.
 */
package owl.logic.propositional.sat;

import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.collections.Collections3;
import owl.logic.propositional.ConjunctiveNormalForm;
import owl.logic.propositional.PropositionalFormula;
import owl.logic.propositional.sat.IncrementalSolver;
import owl.logic.propositional.sat.JbddIncrementalSolver;

public final class Solver {
    private static final Engine DEFAULT_ENGINE = Engine.JBDD;

    private Solver() {
    }

    public static IncrementalSolver incrementalSolver() {
        return Solver.incrementalSolver(DEFAULT_ENGINE);
    }

    public static IncrementalSolver incrementalSolver(Engine engine) {
        assert (engine == Engine.JBDD);
        return new JbddIncrementalSolver();
    }

    public static Optional<BitSet> model(ImmutableIntArray clauses) {
        return Solver.model(clauses, DEFAULT_ENGINE);
    }

    public static Optional<BitSet> model(ImmutableIntArray clauses, Engine engine) {
        IncrementalSolver incrementalSolver = Solver.incrementalSolver(engine);
        incrementalSolver.pushClauses(clauses);
        return incrementalSolver.model();
    }

    public static <V> Optional<Set<V>> model(PropositionalFormula<V> formula) {
        return Solver.model(formula, DEFAULT_ENGINE);
    }

    public static <V> Optional<Set<V>> model(PropositionalFormula<V> preFormula, Engine engine) {
        PropositionalFormula<V> formula = preFormula.nnf();
        if (formula instanceof PropositionalFormula.Disjunction) {
            for (PropositionalFormula disjunct : ((PropositionalFormula.Disjunction)formula).disjuncts) {
                Optional<Set<V>> satisfiable = Solver.model(disjunct, engine);
                if (!satisfiable.isPresent()) continue;
                return satisfiable;
            }
            return Optional.empty();
        }
        Map<PropositionalFormula.Polarity, PropositionalFormula.Polarity> polarity = formula.polarity();
        PropositionalFormula simplifiedFormula = formula.substitute(variable -> {
            switch ((PropositionalFormula.Polarity)((Object)((Object)polarity.get(variable)))) {
                case POSITIVE: {
                    return PropositionalFormula.trueConstant();
                }
                case NEGATIVE: {
                    return PropositionalFormula.falseConstant();
                }
            }
            return PropositionalFormula.Variable.of(variable);
        });
        ConjunctiveNormalForm conjunctiveNormalForm = new ConjunctiveNormalForm(simplifiedFormula);
        Optional modelSimplifiedFormula = Solver.model(conjunctiveNormalForm.clauses, engine).map(bitSet -> bitSet.stream().map(x -> x + 1).filter(arg_0 -> conjunctiveNormalForm.variableMapping.containsValue(arg_0)).mapToObj(i -> conjunctiveNormalForm.variableMapping.inverse().get((Object)i)).collect(Collectors.toSet()));
        if (modelSimplifiedFormula.isEmpty()) {
            return modelSimplifiedFormula;
        }
        polarity.forEach((variable, value) -> {
            if (value == PropositionalFormula.Polarity.POSITIVE) {
                modelSimplifiedFormula.ifPresent(x -> x.add(variable));
            }
        });
        return modelSimplifiedFormula;
    }

    public static <V> List<Set<V>> maximalModels(PropositionalFormula<V> formula, Set<V> upperBound) {
        return Solver.maximalModels(formula, upperBound, DEFAULT_ENGINE);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> List<Set<V>> maximalModels(PropositionalFormula<V> formula, Set<V> upperBound, Engine engine) {
        Optional<BitSet> model2;
        PropositionalFormula normalisedFormula = formula.substitute(variable -> upperBound.contains(variable) ? PropositionalFormula.Variable.of(variable) : PropositionalFormula.falseConstant()).nnf();
        if (normalisedFormula.evaluate(upperBound)) {
            return List.of(upperBound);
        }
        if (upperBound.size() == 1) {
            return normalisedFormula.evaluate(Set.of()) ? List.of(new HashSet()) : List.of();
        }
        HashSet<V> lowerBound = new HashSet<V>(upperBound);
        normalisedFormula.polarity().forEach((variable, variablePolarity) -> {
            if (variablePolarity != PropositionalFormula.Polarity.POSITIVE) {
                lowerBound.remove(variable);
            }
        });
        if (!lowerBound.isEmpty()) {
            PropositionalFormula restrictedFormula = normalisedFormula.substitute(variable -> lowerBound.contains(variable) ? PropositionalFormula.trueConstant() : PropositionalFormula.Variable.of(variable));
            HashSet<V> hashSet = new HashSet<V>(upperBound.size());
            for (V upperBoundElement : upperBound) {
                if (lowerBound.contains(upperBoundElement)) continue;
                hashSet.add(upperBoundElement);
            }
            List<Set<V>> restrictedMaximalModels = Solver.maximalModels(restrictedFormula, hashSet);
            restrictedMaximalModels.forEach(model -> model.addAll(lowerBound));
            return restrictedMaximalModels;
        }
        if (upperBound.equals(formula.variables()) && normalisedFormula instanceof PropositionalFormula.Disjunction) {
            void var6_10;
            boolean allDisjunctsAreNegatedVariables = true;
            List disjuncts = ((PropositionalFormula.Disjunction)normalisedFormula).disjuncts;
            boolean bl = false;
            int s = disjuncts.size();
            while (var6_10 < s) {
                PropositionalFormula disjunct = (PropositionalFormula)disjuncts.get((int)var6_10);
                if (!(disjunct instanceof PropositionalFormula.Negation) || !(((PropositionalFormula.Negation)disjunct).operand instanceof PropositionalFormula.Variable)) {
                    allDisjunctsAreNegatedVariables = false;
                    break;
                }
                ++var6_10;
            }
            if (allDisjunctsAreNegatedVariables) {
                ArrayList<Set<V>> arrayList = new ArrayList<Set<V>>();
                for (Iterator<PropositionalFormula<Object>> upperBoundElement : upperBound) {
                    HashSet<V> model3 = new HashSet<V>(upperBound);
                    model3.remove(upperBoundElement);
                    assert (normalisedFormula.evaluate(model3));
                    arrayList.add(model3);
                }
                return arrayList;
            }
        }
        List<Object> maximalModels = new ArrayList();
        for (PropositionalFormula propositionalFormula : PropositionalFormula.disjuncts(normalisedFormula)) {
            HashSet<V> potentialModel = new HashSet<V>(upperBound);
            for (PropositionalFormula conjunct : PropositionalFormula.conjuncts(propositionalFormula)) {
                if (!(conjunct instanceof PropositionalFormula.Negation)) continue;
                PropositionalFormula.Negation negation = (PropositionalFormula.Negation)conjunct;
                potentialModel.remove(((PropositionalFormula.Variable)negation.operand).variable);
            }
            if (!normalisedFormula.evaluate(potentialModel)) continue;
            assert (!potentialModel.equals(upperBound));
            assert (upperBound.containsAll(potentialModel));
            maximalModels.add(potentialModel);
        }
        maximalModels = Collections3.maximalElements(maximalModels, (x, y) -> y.containsAll((Collection<?>)x));
        ConjunctiveNormalForm conjunctiveNormalForm = new ConjunctiveNormalForm(normalisedFormula);
        IncrementalSolver incrementalSolver = Solver.incrementalSolver(engine);
        incrementalSolver.pushClauses(conjunctiveNormalForm.clauses);
        maximalModels.forEach(x -> Solver.blockModelAndAllSubsets(incrementalSolver, conjunctiveNormalForm, x));
        while ((model2 = incrementalSolver.model()).isPresent()) {
            BitSet prunedModel = model2.get();
            prunedModel.clear(conjunctiveNormalForm.tsetinVariablesLowerBound - 1, prunedModel.length());
            Set mappedModel = prunedModel.stream().mapToObj(i -> conjunctiveNormalForm.variableMapping.inverse().get((Object)(i + 1))).collect(Collectors.toSet());
            assert (normalisedFormula.evaluate(mappedModel));
            maximalModels.add(mappedModel);
            maximalModels = Collections3.maximalElements(maximalModels, (x, y) -> y.containsAll((Collection<?>)x));
            Solver.blockModelAndAllSubsets(incrementalSolver, conjunctiveNormalForm, mappedModel);
        }
        return maximalModels;
    }

    private static <V> void blockModelAndAllSubsets(IncrementalSolver solver, ConjunctiveNormalForm<V> encoding, Set<V> model) {
        int[] blockingClause = IntStream.range(1, encoding.tsetinVariablesLowerBound).filter(i -> !model.contains(Objects.requireNonNull(encoding.variableMapping.inverse().get((Object)i)))).toArray();
        solver.pushClauses(blockingClause);
    }

    static enum Engine {
        JBDD;

    }
}

