/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.ROperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class UOperator
extends Formula.BinaryTemporalOperator {
    public UOperator(Formula leftOperand, Formula rightOperand) {
        super(UOperator.class, leftOperand, rightOperand);
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (rightOperand instanceof BooleanConstant || rightOperand instanceof FOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.FALSE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.TRUE)) {
            return FOperator.of(rightOperand);
        }
        if (rightOperand instanceof UOperator && leftOperand.equals(((UOperator)rightOperand).leftOperand())) {
            return rightOperand;
        }
        return new UOperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "U";
    }

    @Override
    public Formula nnf() {
        return UOperator.of(this.leftOperand().nnf(), this.rightOperand().nnf());
    }

    @Override
    public Formula not() {
        return ROperator.of(this.leftOperand().not(), this.rightOperand().not());
    }

    @Override
    public Formula unfold() {
        return Disjunction.of(this.rightOperand().unfold(), Conjunction.of(this.leftOperand().unfold(), (Formula)this));
    }
}

