/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import com.google.common.collect.Comparators;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.Negation;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public final class PrintVisitor
implements Visitor<String> {
    private final boolean parenthesize;
    @Nullable
    private final List<String> atomicPropositions;

    private PrintVisitor(boolean parenthesize, @Nullable List<String> atomicPropositions) {
        this.atomicPropositions = atomicPropositions == null ? atomicPropositions : List.copyOf(atomicPropositions);
        this.parenthesize = parenthesize;
    }

    public static String toString(LabelledFormula formula, boolean parenthesize) {
        PrintVisitor visitor = new PrintVisitor(parenthesize, formula.atomicPropositions());
        return formula.formula().accept(visitor);
    }

    @Override
    public String visit(Biconditional biconditional) {
        return "(" + this.visitParenthesized(biconditional.leftOperand()) + " <-> " + this.visitParenthesized(biconditional.rightOperand()) + ")";
    }

    @Override
    public String visit(BooleanConstant booleanConstant) {
        return booleanConstant.toString();
    }

    @Override
    public String visit(Conjunction conjunction) {
        assert (Comparators.isInStrictOrder((Iterable)conjunction.operands, Comparator.naturalOrder()));
        return "(" + conjunction.operands.stream().map(this::visitParenthesized).collect(Collectors.joining(" & ")) + ")";
    }

    @Override
    public String visit(Disjunction disjunction) {
        assert (Comparators.isInStrictOrder((Iterable)disjunction.operands, Comparator.naturalOrder()));
        return "(" + disjunction.operands.stream().map(this::visitParenthesized).collect(Collectors.joining(" | ")) + ")";
    }

    @Override
    public String visit(FOperator fOperator) {
        return this.visit((Formula.UnaryTemporalOperator)fOperator);
    }

    @Override
    public String visit(GOperator gOperator) {
        return this.visit((Formula.UnaryTemporalOperator)gOperator);
    }

    @Override
    public String visit(Negation negation) {
        return "! " + this.visitParenthesized(negation.operand());
    }

    @Override
    public String visit(Literal literal) {
        String name = this.atomicPropositions == null ? "p" + literal.getAtom() : this.atomicPropositions.get(literal.getAtom());
        return literal.isNegated() ? "!" + name : name;
    }

    @Override
    public String visit(MOperator mOperator) {
        return this.visit((Formula.BinaryTemporalOperator)mOperator);
    }

    @Override
    public String visit(ROperator rOperator) {
        return this.visit((Formula.BinaryTemporalOperator)rOperator);
    }

    @Override
    public String visit(UOperator uOperator) {
        return this.visit((Formula.BinaryTemporalOperator)uOperator);
    }

    @Override
    public String visit(WOperator wOperator) {
        return this.visit((Formula.BinaryTemporalOperator)wOperator);
    }

    @Override
    public String visit(XOperator xOperator) {
        return this.visit((Formula.UnaryTemporalOperator)xOperator);
    }

    private String visit(Formula.UnaryTemporalOperator operator) {
        return operator.operatorSymbol() + this.visitParenthesized(operator.operand());
    }

    private String visit(Formula.BinaryTemporalOperator operator) {
        return "((" + operator.leftOperand().accept(this) + ") " + operator.operatorSymbol() + " (" + operator.rightOperand().accept(this) + "))";
    }

    private String visitParenthesized(Formula formula) {
        return this.parenthesize ? "(" + formula.accept(this) + ")" : formula.accept(this);
    }
}

