/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import owl.Bibliography;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.degeneralization.RabinDegeneralization;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.cinterface.CInterface;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierRepository;
import owl.translations.canonical.AbstractPortfolio;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.canonical.NonDeterministicConstructionsPortfolio;
import owl.translations.delag.DelagBuilder;
import owl.translations.ltl2dela.NormalformDELAConstruction;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.ltl2dpa.NormalformDPAConstruction;
import owl.translations.ltl2dpa.SymbolicDPAConstruction;
import owl.translations.ltl2dra.NormalformDRAConstruction;
import owl.translations.ltl2dra.SymmetricDRAConstruction;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.ltl2nba.SymmetricNBAConstruction;
import owl.translations.rabinizer.RabinizerBuilder;
import owl.translations.rabinizer.RabinizerConfiguration;
import owl.translations.rabinizer.RabinizerState;
import owl.util.ParallelEvaluation;

@CContext(value=CInterface.CDirectives.class)
public final class LtlTranslationRepository {
    private LtlTranslationRepository() {
    }

    public static <A extends EmersonLeiAcceptance> Function<LabelledFormula, Automaton<?, ? extends A>> defaultTranslation(BranchingMode branchingMode, Class<? extends A> acceptance) {
        return LtlTranslationRepository.defaultTranslation(Option.defaultOptions(), branchingMode, acceptance);
    }

    public static <A extends EmersonLeiAcceptance> Function<LabelledFormula, Automaton<?, ? extends A>> defaultTranslation(Set<Option> translationOptions, BranchingMode branchingMode, Class<? extends A> acceptance) {
        Function<LabelledFormula, Automaton<?, EmersonLeiAcceptance>> translation = null;
        switch (branchingMode) {
            case NON_DETERMINISTIC: {
                if (!GeneralizedBuchiAcceptance.class.isAssignableFrom(acceptance)) break;
                translation = LtlToNbaTranslation.DEFAULT.translation(acceptance.asSubclass(GeneralizedBuchiAcceptance.class), translationOptions);
                break;
            }
            case LIMIT_DETERMINISTIC: {
                if (!GeneralizedBuchiAcceptance.class.isAssignableFrom(acceptance)) break;
                translation = LtlToLdbaTranslation.DEFAULT.translation(acceptance.asSubclass(GeneralizedBuchiAcceptance.class), translationOptions);
                break;
            }
            case DETERMINISTIC: {
                if (ParityAcceptance.class.equals(acceptance)) {
                    translation = LtlToDpaTranslation.DEFAULT.translation(ParityAcceptance.class, translationOptions);
                    break;
                }
                if (GeneralizedRabinAcceptance.class.isAssignableFrom(acceptance)) {
                    translation = LtlToDraTranslation.DEFAULT.translation(acceptance.asSubclass(GeneralizedRabinAcceptance.class), translationOptions);
                    break;
                }
                if (!EmersonLeiAcceptance.class.equals(acceptance)) break;
                translation = LtlToDelaTranslation.DEFAULT.translation(EmersonLeiAcceptance.class, translationOptions);
                break;
            }
            default: {
                throw new AssertionError((Object)"unreachable.");
            }
        }
        if (translation == null) {
            throw LtlTranslationRepository.iae();
        }
        Function<LabelledFormula, Automaton<?, ParityAcceptance>> finalTranslation = translation;
        return x -> OmegaAcceptanceCast.cast((Automaton)finalTranslation.apply((LabelledFormula)x), acceptance);
    }

    public static <A extends EmersonLeiAcceptance> Function<LabelledFormula, Automaton<?, ? extends A>> smallestAutomaton(BranchingMode branchingMode, Class<? extends A> acceptance) {
        Function<LabelledFormula, Automaton<?, EmersonLeiAcceptance>> translation = null;
        Set<Option> translationOptions = Option.defaultOptions();
        switch (branchingMode) {
            case NON_DETERMINISTIC: {
                if (GeneralizedBuchiAcceptance.class.isAssignableFrom(acceptance)) {
                    translation = LtlToNbaTranslation.EKS20.translation(acceptance.asSubclass(GeneralizedBuchiAcceptance.class), translationOptions);
                    break;
                }
                if (!OmegaAcceptanceCast.isInstanceOf(GeneralizedBuchiAcceptance.class, acceptance) && !OmegaAcceptanceCast.isInstanceOf(BuchiAcceptance.class, acceptance)) break;
                boolean generalised = OmegaAcceptanceCast.isInstanceOf(GeneralizedBuchiAcceptance.class, acceptance);
                EnumSet<Option> copiedTranslationOptions = EnumSet.copyOf(translationOptions);
                copiedTranslationOptions.remove((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS);
                Function portfolioTranslation = LtlTranslationRepository.portfolioWithPreAndPostProcessing(BranchingMode.NON_DETERMINISTIC, translationOptions, acceptance);
                translation = labelledFormula -> {
                    Supplier<Optional> eks20translation = () -> Optional.of(generalised ? LtlToNbaTranslation.EKS20.translation(GeneralizedBuchiAcceptance.class, copiedTranslationOptions).apply((LabelledFormula)labelledFormula) : LtlToNbaTranslation.EKS20.translation(BuchiAcceptance.class, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                    return ParallelEvaluation.takeSmallestWildcardStateType(ParallelEvaluation.evaluate(List.of(() -> (Optional)portfolioTranslation.apply((LabelledFormula)labelledFormula), eks20translation)));
                };
                break;
            }
            case LIMIT_DETERMINISTIC: {
                if (!GeneralizedBuchiAcceptance.class.isAssignableFrom(acceptance)) break;
                translation = LtlToLdbaTranslation.SMALLEST_AUTOMATON.translation(acceptance.asSubclass(GeneralizedBuchiAcceptance.class), translationOptions);
                break;
            }
            case DETERMINISTIC: {
                if (ParityAcceptance.class.equals(acceptance)) {
                    translation = LtlToDpaTranslation.SMALLEST_AUTOMATON.translation(ParityAcceptance.class, translationOptions);
                    break;
                }
                if (GeneralizedRabinAcceptance.class.isAssignableFrom(acceptance)) {
                    translation = LtlToDraTranslation.SMALLEST_AUTOMATON.translation(acceptance.asSubclass(GeneralizedRabinAcceptance.class), translationOptions);
                    break;
                }
                if (!EmersonLeiAcceptance.class.isAssignableFrom(acceptance)) break;
                translation = LtlToDelaTranslation.MS17.translation(EmersonLeiAcceptance.class, translationOptions);
                break;
            }
            default: {
                throw new AssertionError((Object)"unreachable.");
            }
        }
        if (translation == null) {
            throw LtlTranslationRepository.iae();
        }
        Function<LabelledFormula, Automaton<?, ParityAcceptance>> finalTranslation = translation;
        return labelledFormula -> {
            Automaton automaton = (Automaton)finalTranslation.apply((LabelledFormula)labelledFormula);
            assert (acceptance.isInstance(automaton.acceptance()));
            Automaton castedAutomaton = automaton;
            return castedAutomaton;
        };
    }

    private static IllegalArgumentException iae() {
        return new IllegalArgumentException("Unsupported Combination");
    }

    private static void assertCiteKey(String expected, String actual) {
        int lastIndex = actual.lastIndexOf(95);
        String normalisedActual = actual.substring(lastIndex + 1);
        assert (expected.equals(normalisedActual));
        assert (Bibliography.INDEX.containsKey(expected));
    }

    private static <A extends EmersonLeiAcceptance> Function<LabelledFormula, Automaton<?, ? extends A>> applyPreAndPostProcessing(Function<LabelledFormula, ? extends Automaton<?, ? extends A>> function, BranchingMode branchingMode, Set<Option> translationOptions, Class<A> acceptanceCondition) {
        Function<LabelledFormula, Automaton<Object, Object>> wrappedFunction;
        boolean simplifyFormula = translationOptions.contains((Object)Option.SIMPLIFY_FORMULA);
        boolean simplifyAutomaton = translationOptions.contains((Object)Option.SIMPLIFY_AUTOMATON);
        boolean completeAutomaton = translationOptions.contains((Object)Option.COMPLETE);
        if (translationOptions.contains((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS)) {
            AbstractPortfolio portfolio = branchingMode == BranchingMode.NON_DETERMINISTIC ? new NonDeterministicConstructionsPortfolio<A>(acceptanceCondition) : new DeterministicConstructionsPortfolio<A>(acceptanceCondition);
            wrappedFunction = labelledFormula -> ((Optional)portfolio.apply(labelledFormula)).orElseGet(() -> (Automaton)function.apply((LabelledFormula)labelledFormula));
        } else {
            wrappedFunction = function;
        }
        return unprocessedFormula -> {
            Automaton automaton;
            LabelledFormula formula = simplifyFormula ? SimplifierRepository.SYNTACTIC_FIXPOINT.apply((LabelledFormula)unprocessedFormula) : unprocessedFormula;
            Automaton automaton2 = automaton = simplifyAutomaton ? AcceptanceOptimizations.transform((Automaton)wrappedFunction.apply(formula)) : (Automaton)wrappedFunction.apply(formula);
            if (completeAutomaton) {
                if (automaton.acceptance() instanceof AllAcceptance && acceptanceCondition.equals(GeneralizedBuchiAcceptance.class)) {
                    return OmegaAcceptanceCast.cast(Views.complete(OmegaAcceptanceCast.cast(automaton, BuchiAcceptance.class)), acceptanceCondition);
                }
                return OmegaAcceptanceCast.cast(Views.complete(automaton), acceptanceCondition);
            }
            return automaton;
        };
    }

    private static <A extends EmersonLeiAcceptance> Function<LabelledFormula, Optional<Automaton<?, ? extends A>>> portfolioWithPreAndPostProcessing(BranchingMode branchingMode, Set<Option> translationOptions, Class<A> acceptanceCondition) {
        if (!translationOptions.contains((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS)) {
            return x -> Optional.empty();
        }
        boolean simplifyFormula = translationOptions.contains((Object)Option.SIMPLIFY_FORMULA);
        boolean simplifyAutomaton = translationOptions.contains((Object)Option.SIMPLIFY_AUTOMATON);
        boolean completeAutomaton = translationOptions.contains((Object)Option.COMPLETE);
        AbstractPortfolio portfolio = branchingMode == BranchingMode.NON_DETERMINISTIC ? new NonDeterministicConstructionsPortfolio<A>(acceptanceCondition) : new DeterministicConstructionsPortfolio<A>(acceptanceCondition);
        return unprocessedFormula -> {
            Automaton automaton;
            LabelledFormula formula = simplifyFormula ? SimplifierRepository.SYNTACTIC_FIXPOINT.apply((LabelledFormula)unprocessedFormula) : unprocessedFormula;
            Optional automatonOptional = (Optional)portfolio.apply(formula);
            if (automatonOptional.isEmpty()) {
                return Optional.empty();
            }
            Automaton automaton2 = automaton = simplifyAutomaton ? AcceptanceOptimizations.transform((Automaton)automatonOptional.get()) : (Automaton)automatonOptional.get();
            if (completeAutomaton) {
                if (automaton.acceptance() instanceof AllAcceptance && acceptanceCondition.equals(GeneralizedBuchiAcceptance.class)) {
                    return Optional.of(OmegaAcceptanceCast.cast(Views.complete(OmegaAcceptanceCast.cast(automaton, BuchiAcceptance.class)), acceptanceCondition));
                }
                return Optional.of(OmegaAcceptanceCast.cast(Views.complete(automaton), acceptanceCondition));
            }
            return Optional.of(automaton);
        };
    }

    public static enum LtlToDelaTranslation implements LtlTranslation<EmersonLeiAcceptance, EmersonLeiAcceptance>
    {
        MS17("MS17"),
        SLM21("SLM21"),
        SMALLEST_AUTOMATON(null);

        public static final LtlToDelaTranslation DEFAULT;
        public static final String MS17_DESCRIPTION = "Translate the formula to a deterministic Emerson-Lei automaton using an specialised product construction and a portfolio of constructions for simple LTL fragments. This construction has been originally be implemented in 'delag' and presented in [MS17]. If a subformula is not in a supported fragment then [EKS20] is used as a fallback.";
        public static final String SLM21_DESCRIPTION = "Translate the formula to a deterministic Emerson-Lei automaton by rewriting the formula locally into the \u0394\u2082-normalform using the procedure of [SE20], i.e., only temporal subformulas that are not in \u0394\u2082 are rewritten, and then use an specialised product construction [SLM21] to obtain a deterministic automaton. After rewriting each temporal subformula is in \u03a3\u2082 or \u03a0\u2082 and the direct translation to deterministic co-B\u00fcchi and B\u00fcchi automata from [SLM21] is sufficient.";
        public static final String SMALLEST_AUTOMATON_DESCRIPTION = "Run all available DELA- and DGRA-translations with all optimisations turned on in parallel and return the smallest automaton.";

        private LtlToDelaTranslation(String citeKey) {
            if (citeKey != null) {
                LtlTranslationRepository.assertCiteKey(citeKey, this.citeKey());
            }
        }

        @Override
        public Class<EmersonLeiAcceptance> acceptanceClassLowerBound() {
            return EmersonLeiAcceptance.class;
        }

        @Override
        public Class<EmersonLeiAcceptance> acceptanceClassUpperBound() {
            return EmersonLeiAcceptance.class;
        }

        @Override
        public <A extends EmersonLeiAcceptance> Function<LabelledFormula, Automaton<?, ? extends A>> translation(Class<A> acceptanceClass, Set<Option> translationOptions, OptionalInt lookahead) {
            Preconditions.checkArgument((boolean)this.acceptanceClassWithinBounds(acceptanceClass));
            switch (this) {
                case MS17: {
                    DelagBuilder ms17construction = new DelagBuilder(LtlToDraTranslation.EKS20.translation(GeneralizedRabinAcceptance.class));
                    return LtlTranslationRepository.applyPreAndPostProcessing(x -> OmegaAcceptanceCast.cast(ms17construction.apply((LabelledFormula)x), acceptanceClass), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SLM21: {
                    NormalformDELAConstruction slm21Construction = new NormalformDELAConstruction(lookahead);
                    return LtlTranslationRepository.applyPreAndPostProcessing(x -> OmegaAcceptanceCast.cast(slm21Construction.apply((LabelledFormula)x), acceptanceClass), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SMALLEST_AUTOMATON: {
                    EnumSet<Option> copiedTranslationOptions = EnumSet.copyOf(translationOptions);
                    copiedTranslationOptions.add(Option.X_DRA_NORMAL_FORM_USE_DUAL);
                    copiedTranslationOptions.remove((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS);
                    Function portfolioTranslation = LtlTranslationRepository.portfolioWithPreAndPostProcessing(BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                    return labelledFormula -> {
                        Supplier<Optional> ms17translation = () -> Optional.of(MS17.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> slm21translation = () -> Optional.of(SLM21.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> dgraTranslation = () -> Optional.of(OmegaAcceptanceCast.cast(LtlToDraTranslation.SMALLEST_AUTOMATON.translation(GeneralizedRabinAcceptance.class, copiedTranslationOptions).apply((LabelledFormula)labelledFormula), acceptanceClass));
                        return ParallelEvaluation.takeSmallestWildcardStateType(ParallelEvaluation.evaluate(List.of(() -> (Optional)portfolioTranslation.apply((LabelledFormula)labelledFormula), ms17translation, slm21translation, dgraTranslation)));
                    };
                }
            }
            throw new AssertionError((Object)"Unreachable.");
        }

        static {
            DEFAULT = SLM21;
        }
    }

    public static enum LtlToDraTranslation implements LtlTranslation<RabinAcceptance, GeneralizedRabinAcceptance>
    {
        EKS16("EKS16"),
        EKS20("EKS20"),
        SE20("SE20"),
        SMALLEST_AUTOMATON(null);

        public static final LtlToDraTranslation DEFAULT;
        public static final String EKS16_DESCRIPTION = "Translate the formula to a deterministic (generalised) Rabin automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton. This construction is also known as the original 'Rabinizer'-construction [EKS16] and used to be available through the '--asymmetric' option.";
        public static final String EKS20_DESCRIPTION = "Translate the formula to a deterministic (generalised) Rabin automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton and the set of least fixed-point operators, i.e. F, M, and U, that is satisfied by infinitely many suffixes of the word read by the automaton. This construction has been initially proposed in [EKS18] and has been described in more detail and with optimisations in [S19]. The preferred reference to cite is the journal article [EKS20]. The translation used to be available through the '--symmetric' option.";
        public static final String SE20_DESCRIPTION = "Translate the formula to a deterministic (generalised) Rabin automaton by rewriting the formula into the \u0394\u2082-normalform using the procedure of [SE20] and then by using the constructions for 'simple' LTL fragments from [SE20, S19].";
        public static final String SMALLEST_AUTOMATON_DESCRIPTION = "Run all available D(G)RA-translations with all optimisations turned on in parallel and return the smallest automaton.";

        private LtlToDraTranslation(String citeKey) {
            if (citeKey != null) {
                LtlTranslationRepository.assertCiteKey(citeKey, this.citeKey());
            }
        }

        @Override
        public Class<RabinAcceptance> acceptanceClassLowerBound() {
            return RabinAcceptance.class;
        }

        @Override
        public Class<GeneralizedRabinAcceptance> acceptanceClassUpperBound() {
            return GeneralizedRabinAcceptance.class;
        }

        @Override
        public <R extends GeneralizedRabinAcceptance> Function<LabelledFormula, Automaton<?, ? extends R>> translation(Class<R> acceptanceClass, Set<Option> translationOptions, OptionalInt lookahead) {
            Preconditions.checkArgument((boolean)this.acceptanceClassWithinBounds(acceptanceClass));
            switch (this) {
                case EKS16: {
                    Function<LabelledFormula, Automaton> eks16construction = labelledFormula -> {
                        MutableAutomaton<RabinizerState, GeneralizedRabinAcceptance> dgra = RabinizerBuilder.build(labelledFormula, RabinizerConfiguration.of(true, true, true));
                        if (acceptanceClass.equals(GeneralizedRabinAcceptance.class)) {
                            return OmegaAcceptanceCast.cast(dgra, acceptanceClass);
                        }
                        return OmegaAcceptanceCast.cast(RabinDegeneralization.degeneralize(AcceptanceOptimizations.transform(dgra)), acceptanceClass);
                    };
                    return LtlTranslationRepository.applyPreAndPostProcessing(eks16construction, BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case EKS20: {
                    return LtlTranslationRepository.applyPreAndPostProcessing(SymmetricDRAConstruction.of(acceptanceClass, true), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SE20: {
                    return LtlTranslationRepository.applyPreAndPostProcessing(NormalformDRAConstruction.of(acceptanceClass, translationOptions.contains((Object)Option.X_DRA_NORMAL_FORM_USE_DUAL)), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SMALLEST_AUTOMATON: {
                    EnumSet<Option> copiedTranslationOptions = EnumSet.copyOf(translationOptions);
                    copiedTranslationOptions.add(Option.X_DRA_NORMAL_FORM_USE_DUAL);
                    copiedTranslationOptions.remove((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS);
                    Function portfolioTranslation = LtlTranslationRepository.portfolioWithPreAndPostProcessing(BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                    return labelledFormula -> {
                        Supplier<Optional> sejk16translation = () -> Optional.of(EKS16.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> eks20translation = () -> Optional.of(EKS20.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> se20translation = () -> Optional.of(SE20.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        return ParallelEvaluation.takeSmallestWildcardStateType(ParallelEvaluation.evaluate(List.of(() -> (Optional)portfolioTranslation.apply((LabelledFormula)labelledFormula), sejk16translation, eks20translation, se20translation)));
                    };
                }
            }
            throw new AssertionError((Object)"Unreachable.");
        }

        static {
            DEFAULT = EKS20;
        }
    }

    @CEnum(value="ltl_to_dpa_translation_t")
    public static enum LtlToDpaTranslation implements LtlTranslation<ParityAcceptance, ParityAcceptance>
    {
        SEJK16_EKRS17("EKRS17"),
        EKS20_EKRS17("EKRS17"),
        SYMBOLIC_SE20_BKS10("BKS10"),
        SLM21("SLM21"),
        SMALLEST_AUTOMATON(null);

        public static final LtlToDpaTranslation DEFAULT;
        public static final String SEJK16_EKRS17_DESCRIPTION = "Translate the formula to a deterministic parity automaton by combining [SEJK16] with the LDBA-to-DPA translation of [EKRS17]. This translation used to be available through the '--asymmetric' option.";
        public static final String EKS20_EKRS17_DESCRIPTION = "Translate the formula to a deterministic parity automaton by combining [EKS20] with the LDBA-to-DPA translation of [EKRS17]. This translation used to be available through the '--symmetric' option.";
        public static final String SYMBOLIC_SE20_BKS10_DESCRIPTION = "Translate the formula to a deterministic parity automaton by combining the LTL-to-DRA translation of [SE20] with DRAxDSA-to-DPA result of [BKS10]. This translation has an _symbolic_ implementation and is provided for testing purposes through this interface. In order to benefit from the symbolic implementation users _must_ use the 'SymbolicAutomaton'-interface.";
        public static final String SLM21_DESCRIPTION = "Translate the formula to a deterministic parity automaton by combining the LTL-to-DELA translation of [SLM21] with a DELW-to-DPW translation based on Zielonka-trees. Depending on the lookahead either [CCF21]  or [SLM21] is used.";
        public static final String SMALLEST_AUTOMATON_DESCRIPTION = "Run all available DPA-translations with all optimisations turned on in parallel and return the smallest automaton.";

        private LtlToDpaTranslation(String citeKey) {
            if (citeKey != null) {
                LtlTranslationRepository.assertCiteKey(citeKey, this.citeKey());
            }
        }

        @Override
        public Class<ParityAcceptance> acceptanceClassLowerBound() {
            return ParityAcceptance.class;
        }

        @Override
        public Class<ParityAcceptance> acceptanceClassUpperBound() {
            return ParityAcceptance.class;
        }

        @Override
        public <A extends ParityAcceptance> Function<LabelledFormula, Automaton<?, ? extends A>> translation(Class<A> acceptanceClass, Set<Option> translationOptions, OptionalInt lookahead) {
            Preconditions.checkArgument((boolean)this.acceptanceClassWithinBounds(acceptanceClass));
            switch (this) {
                case SEJK16_EKRS17: {
                    EnumSet<LTL2DPAFunction.Configuration> configuration = EnumSet.of(LTL2DPAFunction.Configuration.POST_PROCESS);
                    if (translationOptions.contains((Object)Option.X_DPA_USE_COMPLEMENT)) {
                        configuration.add(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_EXACT);
                    }
                    LTL2DPAFunction ekrs17translation = new LTL2DPAFunction(configuration);
                    return LtlTranslationRepository.applyPreAndPostProcessing(x -> OmegaAcceptanceCast.cast(ekrs17translation.apply((LabelledFormula)x), acceptanceClass), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case EKS20_EKRS17: {
                    EnumSet<LTL2DPAFunction.Configuration> configuration = EnumSet.of(LTL2DPAFunction.Configuration.SYMMETRIC, LTL2DPAFunction.Configuration.POST_PROCESS);
                    if (translationOptions.contains((Object)Option.X_DPA_USE_COMPLEMENT)) {
                        configuration.add(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_EXACT);
                    }
                    LTL2DPAFunction ekrs17translation = new LTL2DPAFunction(configuration);
                    return LtlTranslationRepository.applyPreAndPostProcessing(x -> OmegaAcceptanceCast.cast(ekrs17translation.apply((LabelledFormula)x), acceptanceClass), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SYMBOLIC_SE20_BKS10: {
                    return LtlTranslationRepository.applyPreAndPostProcessing(x -> OmegaAcceptanceCast.cast(SymbolicDPAConstruction.of().apply((LabelledFormula)x).toAutomaton(), acceptanceClass), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SLM21: {
                    NormalformDPAConstruction translation = new NormalformDPAConstruction(lookahead);
                    return LtlTranslationRepository.applyPreAndPostProcessing(x -> OmegaAcceptanceCast.cast(translation.apply((LabelledFormula)x), acceptanceClass), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SMALLEST_AUTOMATON: {
                    EnumSet<Option> copiedTranslationOptions = EnumSet.copyOf(translationOptions);
                    copiedTranslationOptions.add(Option.X_DPA_USE_COMPLEMENT);
                    copiedTranslationOptions.remove((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS);
                    Function portfolioTranslation = LtlTranslationRepository.portfolioWithPreAndPostProcessing(BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                    return labelledFormula -> {
                        Supplier<Optional> sejk16translation = () -> Optional.of(SEJK16_EKRS17.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> eks20translation = () -> Optional.of(EKS20_EKRS17.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> se20bks10SymbolicTranslation = () -> Optional.of(SYMBOLIC_SE20_BKS10.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> slm21translation = () -> Optional.of(SLM21.translation(acceptanceClass, copiedTranslationOptions, OptionalInt.empty()).apply((LabelledFormula)labelledFormula));
                        return ParallelEvaluation.takeSmallestWildcardStateType(ParallelEvaluation.evaluate(List.of(() -> (Optional)portfolioTranslation.apply((LabelledFormula)labelledFormula), sejk16translation, eks20translation, se20bks10SymbolicTranslation, slm21translation)));
                    };
                }
            }
            throw new AssertionError((Object)"Unreachable.");
        }

        @CEnumValue
        public native int getCValue();

        @CEnumLookup
        public static native LtlToDpaTranslation fromCValue(int var0);

        static {
            DEFAULT = SLM21;
        }
    }

    public static enum LtlToLdbaTranslation implements LtlTranslation<BuchiAcceptance, GeneralizedBuchiAcceptance>
    {
        SEJK16("SEJK16"),
        EKS20("EKS20"),
        SMALLEST_AUTOMATON(null);

        public static final LtlToLdbaTranslation DEFAULT;
        public static final String SEJK16_DESCRIPTION = "Translate the formula to a limit-deterministic (generalised) B\u00fcchi automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton. The construction is an optimised version of the construction appearing in [SEJK16] and used to be available through the '--asymmetric' option.";
        public static final String EKS20_DESCRIPTION = "Translate the formula to a limit-deterministic (generalised) B\u00fcchi automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton and the set of least fixed-point operators, i.e. F, M, and U, that is satisfied by infinitely many suffixes of the word read by the automaton. This construction has been initially proposed in [EKS18] and has been described in more detail and with optimisations in [S19]. The preferred reference to cite is the journal article [EKS20]. The translation used to be available through the '--symmetric' option.";
        public static final String SMALLEST_AUTOMATON_DESCRIPTION = "Run all available LD(G)BA-translations in parallel and return the smallest automaton.";

        private LtlToLdbaTranslation(String citeKey) {
            if (citeKey != null) {
                LtlTranslationRepository.assertCiteKey(citeKey, this.citeKey());
            }
        }

        @Override
        public Class<BuchiAcceptance> acceptanceClassLowerBound() {
            return BuchiAcceptance.class;
        }

        @Override
        public Class<GeneralizedBuchiAcceptance> acceptanceClassUpperBound() {
            return GeneralizedBuchiAcceptance.class;
        }

        @Override
        public <B extends GeneralizedBuchiAcceptance> Function<LabelledFormula, Automaton<?, ? extends B>> translation(Class<B> acceptanceClass, Set<Option> translationOptions, OptionalInt lookahead) {
            Preconditions.checkArgument((boolean)this.acceptanceClassWithinBounds(acceptanceClass));
            switch (this) {
                case SEJK16: {
                    return LtlTranslationRepository.applyPreAndPostProcessing(AsymmetricLDBAConstruction.of(acceptanceClass).andThen(AnnotatedLDBA::copyAsMutable), BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case EKS20: {
                    return LtlTranslationRepository.applyPreAndPostProcessing(SymmetricLDBAConstruction.of(acceptanceClass)::applyWithShortcuts, BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                }
                case SMALLEST_AUTOMATON: {
                    EnumSet<Option> copiedTranslationOptions = EnumSet.copyOf(translationOptions);
                    copiedTranslationOptions.remove((Object)Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS);
                    Function portfolioTranslation = LtlTranslationRepository.portfolioWithPreAndPostProcessing(BranchingMode.DETERMINISTIC, translationOptions, acceptanceClass);
                    return labelledFormula -> {
                        Supplier<Optional> sejk16translation = () -> Optional.of(SEJK16.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        Supplier<Optional> eks20translation = () -> Optional.of(EKS20.translation(acceptanceClass, copiedTranslationOptions).apply((LabelledFormula)labelledFormula));
                        return ParallelEvaluation.takeSmallestWildcardStateType(ParallelEvaluation.evaluate(List.of(() -> (Optional)portfolioTranslation.apply((LabelledFormula)labelledFormula), sejk16translation, eks20translation)));
                    };
                }
            }
            throw new AssertionError((Object)"Unreachable.");
        }

        static {
            DEFAULT = SEJK16;
        }
    }

    public static final class LtlToNbaTranslation
    extends Enum<LtlToNbaTranslation>
    implements LtlTranslation<BuchiAcceptance, GeneralizedBuchiAcceptance> {
        public static final /* enum */ LtlToNbaTranslation EKS20 = new LtlToNbaTranslation("EKS20");
        public static final LtlToNbaTranslation DEFAULT;
        public static final String EKS20_DESCRIPTION = "Translate the formula to a non-deterministic (generalised) B\u00fcchi automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton and the set of least fixed-point operators, i.e. F, M, and U, that is satisfied by infinitely many suffixes of the word read by the automaton. This construction has been initially proposed in [EKS18] and has been described in more detail and with optimisations in [S19]. The preferred reference to cite is the journal article [EKS20]. The translation used to be available through the '--symmetric' option.";
        private static final /* synthetic */ LtlToNbaTranslation[] $VALUES;

        public static LtlToNbaTranslation[] values() {
            return (LtlToNbaTranslation[])$VALUES.clone();
        }

        public static LtlToNbaTranslation valueOf(String name) {
            return Enum.valueOf(LtlToNbaTranslation.class, name);
        }

        private LtlToNbaTranslation(String citeKey) {
            LtlTranslationRepository.assertCiteKey(citeKey, this.citeKey());
        }

        @Override
        public Class<BuchiAcceptance> acceptanceClassLowerBound() {
            return BuchiAcceptance.class;
        }

        @Override
        public Class<GeneralizedBuchiAcceptance> acceptanceClassUpperBound() {
            return GeneralizedBuchiAcceptance.class;
        }

        @Override
        public <B extends GeneralizedBuchiAcceptance> Function<LabelledFormula, Automaton<?, ? extends B>> translation(Class<B> acceptanceClass, Set<Option> translationOptions, OptionalInt lookahead) {
            Preconditions.checkArgument((boolean)this.acceptanceClassWithinBounds(acceptanceClass));
            assert (this == EKS20);
            return LtlTranslationRepository.applyPreAndPostProcessing(SymmetricNBAConstruction.of(acceptanceClass), BranchingMode.NON_DETERMINISTIC, translationOptions, acceptanceClass);
        }

        static {
            $VALUES = new LtlToNbaTranslation[]{EKS20};
            DEFAULT = EKS20;
        }
    }

    @CEnum(value="ltl_translation_option_t")
    public static enum Option {
        SIMPLIFY_FORMULA,
        SIMPLIFY_AUTOMATON,
        USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS,
        COMPLETE,
        X_DPA_USE_COMPLEMENT,
        X_DRA_NORMAL_FORM_USE_DUAL;


        @CEnumValue
        public native int getCValue();

        @CEnumLookup
        public static native Option fromCValue(int var0);

        public static Set<Option> defaultOptions() {
            EnumSet<Option> defaultOptions = EnumSet.allOf(Option.class);
            defaultOptions.remove((Object)COMPLETE);
            return defaultOptions;
        }
    }

    public static enum BranchingMode {
        NON_DETERMINISTIC,
        LIMIT_DETERMINISTIC,
        DETERMINISTIC;

    }

    public static interface LtlTranslation<L extends U, U extends EmersonLeiAcceptance> {
        public Class<L> acceptanceClassLowerBound();

        public Class<U> acceptanceClassUpperBound();

        default public boolean acceptanceClassWithinBounds(Class<? extends U> acceptanceClass) {
            return acceptanceClass.isAssignableFrom(this.acceptanceClassLowerBound()) && this.acceptanceClassUpperBound().isAssignableFrom(acceptanceClass);
        }

        default public String citeKey() {
            return this.toString();
        }

        default public Function<LabelledFormula, Automaton<?, ? extends U>> translation() {
            return this.translation(this.acceptanceClassUpperBound());
        }

        default public Function<LabelledFormula, Automaton<?, ? extends U>> translation(Set<Option> translationOptions) {
            return this.translation(this.acceptanceClassUpperBound(), translationOptions);
        }

        default public <A extends U> Function<LabelledFormula, Automaton<?, ? extends A>> translation(Class<A> acceptanceClass) {
            return this.translation(acceptanceClass, Option.defaultOptions());
        }

        default public <A extends U> Function<LabelledFormula, Automaton<?, ? extends A>> translation(Class<A> acceptanceClass, Set<Option> translationOptions) {
            return this.translation(acceptanceClass, translationOptions, OptionalInt.empty());
        }

        public <A extends U> Function<LabelledFormula, Automaton<?, ? extends A>> translation(Class<A> var1, Set<Option> var2, OptionalInt var3);
    }
}

