/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.translations.canonical.AbstractPortfolio;
import owl.translations.canonical.GenericConstructions;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.canonical.RoundRobinState;

public final class NonDeterministicConstructionsPortfolio<A extends EmersonLeiAcceptance>
extends AbstractPortfolio<A> {
    public NonDeterministicConstructionsPortfolio(Class<A> acceptance) {
        super(acceptance);
    }

    @Override
    public Optional<Automaton<?, ? extends A>> apply(LabelledFormula formula) {
        Collection<Formula> formulas;
        if (this.isAllowed(AllAcceptance.class) && SyntacticFragments.isSafety(formula.formula())) {
            return this.box(NonDeterministicConstructionsPortfolio.safety(formula));
        }
        if (this.isAllowed(BuchiAcceptance.class) && SyntacticFragments.isCoSafety(formula.formula())) {
            return this.box(NonDeterministicConstructionsPortfolio.coSafety(formula));
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrappedFormula = formula.formula();
            while (unwrappedFormula instanceof XOperator) {
                ++xCount;
                unwrappedFormula = ((XOperator)unwrappedFormula).operand();
            }
            int xCountFinal = xCount;
            return this.apply(formula.wrap(unwrappedFormula)).map(x -> GenericConstructions.delay(x, xCountFinal));
        }
        Collection<Formula> collection = formulas = formula.formula() instanceof Conjunction ? formula.formula().operands : Set.of(formula.formula());
        if (this.isAllowed(GeneralizedBuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return this.box(NonDeterministicConstructionsPortfolio.gfCoSafety(formula, true));
        }
        if (this.isAllowed(BuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return this.box(NonDeterministicConstructionsPortfolio.gfCoSafety(formula, false));
        }
        if (this.isAllowed(BuchiAcceptance.class) && SyntacticFragments.isFgSafety(formula.formula())) {
            return this.box(NonDeterministicConstructionsPortfolio.fgSafety(formula));
        }
        return Optional.empty();
    }

    public static Automaton<Formula, BuchiAcceptance> coSafety(LabelledFormula formula) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        return NonDeterministicConstructions.CoSafety.of(factories, formula.formula());
    }

    public static Automaton<Formula, AllAcceptance> safety(LabelledFormula formula) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        return NonDeterministicConstructions.Safety.of(factories, formula.formula());
    }

    public static Automaton<RoundRobinState<Formula>, GeneralizedBuchiAcceptance> gfCoSafety(LabelledFormula formula, boolean generalized) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        Set<Formula> formulas = formula.formula() instanceof Conjunction ? Set.copyOf(formula.formula().operands) : Set.of(formula.formula());
        return NonDeterministicConstructions.GfCoSafety.of(factories, formulas, generalized);
    }

    public static Automaton<Formula, BuchiAcceptance> fgSafety(LabelledFormula formula) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        return NonDeterministicConstructions.FgSafety.of(factories, formula.formula());
    }
}

