/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.bdd.EquivalenceClassFactory;
import owl.logic.propositional.PropositionalFormula;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragments;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.delag.DependencyTree;
import owl.translations.delag.ProductState;

class DependencyTreeFactory<T>
extends PropositionalVisitor<DependencyTree<T>> {
    private final ProductState.Builder<T> builder;
    private final Function<Formula, ? extends Automaton<T, ?>> constructor;
    private final EquivalenceClassFactory factory;
    private final Map<Formula, Automaton<T, ?>> automatonCache = new HashMap();
    int setNumber;

    DependencyTreeFactory(EquivalenceClassFactory factory, Function<LabelledFormula, ? extends Automaton<T, ?>> constructor) {
        this.factory = factory;
        this.setNumber = 0;
        this.builder = ProductState.builder();
        this.constructor = formula -> this.automatonCache.computeIfAbsent((Formula)formula, x -> AcceptanceOptimizations.transform((Automaton)constructor.apply(LabelledFormula.of(x, this.factory.atomicPropositions()))));
    }

    ProductState<T> buildInitialState() {
        return this.builder.build();
    }

    @Override
    protected DependencyTree<T> visit(Formula.TemporalOperator formula) {
        return this.defaultAction(formula, null);
    }

    @Override
    public DependencyTree<T> visit(Literal literal) {
        return this.defaultAction(literal, null);
    }

    private DependencyTree<T> defaultAction(Formula formula, @Nullable PropositionalFormula<Integer> piggyback) {
        DependencyTree.Leaf leaf = DependencyTree.createLeaf(formula, this.setNumber, () -> this.constructor.apply(formula), piggyback);
        if (leaf.type == DependencyTree.Type.CO_SAFETY || leaf.type == DependencyTree.Type.SAFETY) {
            this.builder.addSafety(formula, this.factory.of(formula.unfold()));
        }
        if (leaf instanceof DependencyTree.FallbackLeaf) {
            assert (piggyback == null);
            DependencyTree.FallbackLeaf fallbackLeaf = (DependencyTree.FallbackLeaf)leaf;
            this.setNumber += ((EmersonLeiAcceptance)fallbackLeaf.automaton.acceptance()).acceptanceSets();
            Object initialState = Iterables.getOnlyElement(fallbackLeaf.automaton.initialStates(), null);
            if (initialState == null) {
                this.builder.addFinished(fallbackLeaf, Boolean.FALSE);
            } else {
                this.builder.addFallback(formula, initialState);
            }
        } else if (piggyback == null) {
            ++this.setNumber;
        }
        return leaf;
    }

    @Nullable
    private PropositionalFormula<Integer> findPiggybackableLeaf(List<DependencyTree<T>> leafs) {
        for (DependencyTree<T> leaf : leafs) {
            if (!(leaf instanceof DependencyTree.Leaf) || ((DependencyTree.Leaf)leaf).type != DependencyTree.Type.LIMIT_GF && ((DependencyTree.Leaf)leaf).type != DependencyTree.Type.LIMIT_FG) continue;
            return leaf.getAcceptanceExpression();
        }
        return null;
    }

    private List<DependencyTree<T>> group(Iterable<Formula> formulas, List<Formula> safety, List<Formula> coSafety, List<Formula> finite) {
        ArrayList<DependencyTree<T>> children = new ArrayList<DependencyTree<T>>();
        formulas.forEach(x -> {
            if (SyntacticFragments.isFinite(x)) {
                finite.add((Formula)x);
                return;
            }
            if (SyntacticFragments.isCoSafety(x)) {
                coSafety.add((Formula)x);
                return;
            }
            if (SyntacticFragments.isSafety(x)) {
                safety.add((Formula)x);
                return;
            }
            children.add((DependencyTree)x.accept(this));
        });
        return children;
    }

    @Override
    public DependencyTree<T> visit(Disjunction disjunction) {
        ArrayList<Formula> safety = new ArrayList<Formula>();
        ArrayList<Formula> coSafety = new ArrayList<Formula>();
        ArrayList<Formula> finite = new ArrayList<Formula>();
        List<DependencyTree<T>> children = this.group(disjunction.operands, safety, coSafety, finite);
        if (safety.isEmpty()) {
            coSafety.addAll(finite);
        } else {
            safety.addAll(finite);
        }
        if (!safety.isEmpty()) {
            children.add(this.defaultAction(Disjunction.of(safety), this.findPiggybackableLeaf(children)));
        }
        if (!coSafety.isEmpty()) {
            children.add(this.defaultAction(Disjunction.of(coSafety), null));
        }
        return DependencyTree.createOr(children);
    }

    @Override
    public DependencyTree<T> visit(BooleanConstant booleanConstant) {
        throw new IllegalStateException("The input formula should be constant-free.");
    }

    @Override
    public DependencyTree<T> visit(Conjunction conjunction) {
        ArrayList<Formula> safety = new ArrayList<Formula>();
        ArrayList<Formula> coSafety = new ArrayList<Formula>();
        ArrayList<Formula> finite = new ArrayList<Formula>();
        List<DependencyTree<T>> children = this.group(conjunction.operands, safety, coSafety, finite);
        if (coSafety.isEmpty()) {
            safety.addAll(finite);
        } else {
            coSafety.addAll(finite);
        }
        if (!safety.isEmpty()) {
            children.add(this.defaultAction(Conjunction.of(safety), null));
        }
        if (!coSafety.isEmpty()) {
            children.add(this.defaultAction(Conjunction.of(coSafety), this.findPiggybackableLeaf(children)));
        }
        return DependencyTree.createAnd(children);
    }
}

