/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dela;

import com.google.auto.value.AutoValue;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.collections.BitSet2;
import owl.collections.Collections3;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;
import owl.logic.propositional.sat.Solver;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.Negation;
import owl.ltl.SyntacticFragments;
import owl.ltl.rewriter.PropositionalSimplifier;
import owl.ltl.rewriter.PushNextThroughPropositionalVisitor;
import owl.ltl.rewriter.SimplifierRepository;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.BlockingElements;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.ltl2dela.AutoValue_NormalformDELAConstruction_State;
import owl.translations.ltl2dela.PropositionalFormulaHelper;
import owl.translations.mastertheorem.Normalisation;

public final class NormalformDELAConstruction
implements Function<LabelledFormula, Automaton<State, ?>> {
    private static final Normalisation NORMALISATION = Normalisation.of(Normalisation.NormalisationMethod.SE20_SIGMA_2_AND_GF_SIGMA_1, false);
    private static final Normalisation DUAL_NORMALISATION = Normalisation.of(Normalisation.NormalisationMethod.SE20_PI_2_AND_FG_PI_1, false);
    private final OptionalInt lookahead;

    public NormalformDELAConstruction(OptionalInt lookahead) {
        this.lookahead = lookahead;
    }

    @Override
    public Automaton<State, ?> apply(LabelledFormula formula) {
        return this.applyConstruction(formula).automaton();
    }

    public Construction applyConstruction(LabelledFormula formula) {
        LabelledFormula normalisedFormula = RemoveNegation.apply(PushNextThroughPropositionalVisitor.apply(formula));
        return new Construction(normalisedFormula, this.lookahead);
    }

    static enum Classification {
        TERMINAL_ACCEPTING,
        TERMINAL_REJECTING,
        TRANSIENT_SUSPENDED,
        TRANSIENT_NOT_SUSPENDED,
        WEAK_ACCEPTING_SUSPENDED,
        WEAK_ACCEPTING_NOT_SUSPENDED,
        WEAK_REJECTING_SUSPENDED,
        WEAK_REJECTING_NOT_SUSPENDED,
        SUSPENDABLE,
        NOT_SUSPENDABLE;

    }

    static class BreakpointStateRejectingClassifier {
        private final DeterministicConstructions.SafetyCoSafety dbw;
        private final OptionalInt lookahead;
        private final Map<DeterministicConstructions.BreakpointStateRejecting, Classification> memoizedResults = new HashMap<DeterministicConstructions.BreakpointStateRejecting, Classification>();

        BreakpointStateRejectingClassifier(DeterministicConstructions.SafetyCoSafety dbw, OptionalInt lookahead) {
            this.dbw = dbw;
            this.lookahead = lookahead;
        }

        Classification classify(DeterministicConstructions.BreakpointStateRejecting state) {
            Classification classification = this.memoizedResults.get(state);
            if (classification != null) {
                return classification;
            }
            classification = this.classifySyntactically(state);
            if (classification != null) {
                return classification;
            }
            Automaton<DeterministicConstructions.BreakpointStateRejecting, BuchiAcceptance> restrictedDbw = Views.filtered(this.dbw, Views.Filter.builder().initialStates(Set.of(state)).edgeFilter((dbwState, edge) -> !BlockingElements.surelyContainedInDifferentSccs(dbwState.all(), ((DeterministicConstructions.BreakpointStateRejecting)edge.successor()).all())).build());
            if (this.lookahead.isPresent() && !AutomatonUtil.isLessOrEqual(restrictedDbw, this.lookahead.getAsInt())) {
                return this.memoize(state, Classification.NOT_SUSPENDABLE);
            }
            SccDecomposition<DeterministicConstructions.BreakpointStateRejecting> sccDecomposition = SccDecomposition.of(restrictedDbw);
            for (Set<DeterministicConstructions.BreakpointStateRejecting> scc : sccDecomposition.sccs()) {
                for (DeterministicConstructions.BreakpointStateRejecting sccState : scc) {
                    if (this.memoizedResults.containsKey(sccState) || !scc.contains(state) && this.classifySyntactically(sccState) != null) continue;
                    this.classifySemantically(sccState, sccDecomposition);
                }
            }
            classification = this.memoizedResults.get(state);
            assert (classification != null);
            return classification;
        }

        NavigableMap<Integer, Classification> classify(Map<Integer, ? extends DeterministicConstructions.BreakpointStateRejecting> stateMap) {
            TreeMap<Integer, Classification> map = new TreeMap<Integer, Classification>();
            stateMap.forEach((key, state) -> map.put((Integer)key, this.classify((DeterministicConstructions.BreakpointStateRejecting)state)));
            return map;
        }

        @Nullable
        private Classification classifySyntactically(DeterministicConstructions.BreakpointStateRejecting state) {
            assert (!this.memoizedResults.containsKey(state));
            if (state.all().isTrue()) {
                assert (state.isSuspended());
                return this.memoize(state, Classification.TERMINAL_ACCEPTING);
            }
            if (state.all().isFalse()) {
                assert (state.isSuspended());
                return this.memoize(state, Classification.TERMINAL_REJECTING);
            }
            if (this.dbw.suspensionCheck.isBlockedByTransient(state.all())) {
                assert (state.isSuspended());
                return this.memoize(state, Classification.TRANSIENT_SUSPENDED);
            }
            if (this.dbw.suspensionCheck.isBlockedBySafety(state.all())) {
                assert (state.isSuspended());
                return this.memoize(state, Classification.WEAK_ACCEPTING_SUSPENDED);
            }
            if (this.dbw.suspensionCheck.isBlockedByCoSafety(state.all())) {
                assert (state.isSuspended());
                return this.memoize(state, Classification.WEAK_REJECTING_SUSPENDED);
            }
            return null;
        }

        private Classification classifySemantically(DeterministicConstructions.BreakpointStateRejecting state, SccDecomposition<DeterministicConstructions.BreakpointStateRejecting> sccDecomposition) {
            assert (!this.memoizedResults.containsKey(state));
            assert (!state.isSuspended());
            int index = sccDecomposition.index(state);
            if (sccDecomposition.transientSccs().contains(index)) {
                return this.memoize(state, Classification.TRANSIENT_NOT_SUSPENDED);
            }
            if (sccDecomposition.acceptingSccs().contains(index)) {
                return this.memoize(sccDecomposition.sccs().get(index), Classification.WEAK_ACCEPTING_NOT_SUSPENDED);
            }
            if (sccDecomposition.rejectingSccs().contains(index)) {
                return this.memoize(sccDecomposition.sccs().get(index), Classification.WEAK_REJECTING_NOT_SUSPENDED);
            }
            Set<DeterministicConstructions.BreakpointStateRejecting> scc = sccDecomposition.sccs().get(index);
            if (scc.size() == Collections3.transformSet(scc, DeterministicConstructions.BreakpointStateRejecting::all).size()) {
                return this.memoize(scc, Classification.NOT_SUSPENDABLE);
            }
            return this.memoize(scc, Classification.SUSPENDABLE);
        }

        private Classification memoize(DeterministicConstructions.BreakpointStateRejecting state, Classification classification) {
            Classification oldStatus = this.memoizedResults.put(state, classification);
            assert (oldStatus == null || oldStatus == classification);
            return classification;
        }

        private Classification memoize(Set<? extends DeterministicConstructions.BreakpointStateRejecting> scc, Classification classification) {
            scc.forEach(x -> this.memoize((DeterministicConstructions.BreakpointStateRejecting)x, classification));
            return classification;
        }
    }

    @AutoValue
    public static abstract class State {
        public abstract PropositionalFormula<Integer> stateFormula();

        public abstract Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap();

        public abstract ImmutableBitSet roundRobinCounters();

        public static State of(PropositionalFormula<Integer> stateFormula, Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap, BitSet counters) {
            return State.of(stateFormula, stateMap, ImmutableBitSet.copyOf(counters));
        }

        public static State of(PropositionalFormula<Integer> stateFormula, Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap, Set<Integer> counters) {
            assert (stateFormula.variables().equals(stateMap.keySet()));
            assert (stateMap.keySet().containsAll(counters));
            return new AutoValue_NormalformDELAConstruction_State(stateFormula, Map.copyOf(stateMap), ImmutableBitSet.copyOf(counters));
        }

        public boolean inDifferentSccs(State otherState) {
            if (!this.stateFormula().equals(otherState.stateFormula())) {
                return true;
            }
            if (this.stateMap().size() != otherState.stateMap().size()) {
                return true;
            }
            for (Map.Entry<Integer, DeterministicConstructions.BreakpointStateRejecting> entry : this.stateMap().entrySet()) {
                EquivalenceClass all2;
                DeterministicConstructions.BreakpointStateRejecting value2 = otherState.stateMap().get(entry.getKey());
                if (value2 == null) {
                    return true;
                }
                EquivalenceClass all1 = entry.getValue().all();
                if (!BlockingElements.surelyContainedInDifferentSccs(all1, all2 = value2.all())) continue;
                return true;
            }
            return false;
        }
    }

    private static final class InitialStateConstructor
    extends PropositionalVisitor<PropositionalFormula<Integer>> {
        private final DeterministicConstructions.SafetyCoSafety dbw;
        private final List<DeterministicConstructions.BreakpointStateRejecting> initialStates = new ArrayList<DeterministicConstructions.BreakpointStateRejecting>();
        private final BiMap<Formula, Integer> mapping = HashBiMap.create();
        private final Set<Formula.TemporalOperator> nonUnique;
        private final BitSet roundRobinCandidate = new BitSet();

        public InitialStateConstructor(DeterministicConstructions.SafetyCoSafety dbw, Set<Formula.TemporalOperator> nonUnique) {
            this.dbw = dbw;
            this.nonUnique = nonUnique;
        }

        private boolean uniqueReference(Formula.TemporalOperator formula) {
            assert (SyntacticFragments.isSafetyCoSafety(formula) || SyntacticFragments.isCoSafetySafety(formula));
            return !this.nonUnique.contains(formula) && !this.nonUnique.contains((Formula.TemporalOperator)formula.not());
        }

        private PropositionalFormula<Integer> add(Formula formula) {
            if (this.mapping.containsKey((Object)formula)) {
                int id = (Integer)this.mapping.get((Object)formula);
                return PropositionalFormula.Variable.of(id);
            }
            Formula formulaNot = formula.not();
            if (this.mapping.containsKey((Object)formulaNot)) {
                int id = (Integer)this.mapping.get((Object)formulaNot);
                return PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(id));
            }
            if (SyntacticFragments.isSafetyCoSafety(formula)) {
                int id = this.mapping.size();
                DeterministicConstructions.BreakpointStateRejecting initialState = this.dbw.initialState(formula);
                this.mapping.put((Object)formula, (Object)id);
                this.initialStates.add(initialState);
                return PropositionalFormula.Variable.of(id);
            }
            if (SyntacticFragments.isSafetyCoSafety(formulaNot)) {
                int id = this.mapping.size();
                DeterministicConstructions.BreakpointStateRejecting initialState = this.dbw.initialState(formulaNot);
                this.mapping.put((Object)formulaNot, (Object)id);
                this.initialStates.add(initialState);
                return PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(id));
            }
            throw new AssertionError((Object)"should not reach");
        }

        @Override
        protected PropositionalFormula<Integer> visit(Formula.TemporalOperator temporalOperator) {
            return this.add(temporalOperator);
        }

        @Override
        public PropositionalFormula<Integer> visit(Literal literal) {
            return this.add(literal);
        }

        @Override
        public PropositionalFormula<Integer> visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? PropositionalFormula.trueConstant() : PropositionalFormula.falseConstant();
        }

        @Override
        public PropositionalFormula<Integer> visit(Biconditional biconditional) {
            return PropositionalFormula.Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
        }

        @Override
        public PropositionalFormula<Integer> visit(Conjunction conjunction) {
            ArrayList<PropositionalFormula<Integer>> operands = new ArrayList<PropositionalFormula<Integer>>(conjunction.operands.size());
            ArrayList<Formula> weakOrCoSafetySafety = new ArrayList<Formula>();
            for (Formula operand : conjunction.operands) {
                boolean isChainable;
                boolean isWeak = SyntacticFragments.DELTA_1.contains(operand);
                boolean isCoSafetySafetyAndUnique = operand instanceof Formula.TemporalOperator && SyntacticFragments.isCoSafetySafety(operand) && this.uniqueReference((Formula.TemporalOperator)operand);
                boolean bl = isChainable = SyntacticFragments.isGfCoSafety(operand) && this.uniqueReference((Formula.TemporalOperator)operand);
                if (isWeak || isCoSafetySafetyAndUnique) {
                    weakOrCoSafetySafety.add(operand);
                    continue;
                }
                if (isChainable) {
                    assert (operand instanceof GOperator);
                    operands.add(this.add(operand));
                    this.roundRobinCandidate.set((Integer)this.mapping.get((Object)operand));
                    continue;
                }
                operands.add(operand.accept(this));
            }
            if (!weakOrCoSafetySafety.isEmpty()) {
                operands.add(this.add(Conjunction.of(weakOrCoSafetySafety)));
            }
            return PropositionalFormula.Conjunction.of(operands);
        }

        @Override
        public PropositionalFormula<Integer> visit(Disjunction disjunction) {
            ArrayList<PropositionalFormula<Integer>> operands = new ArrayList<PropositionalFormula<Integer>>(disjunction.operands.size());
            ArrayList<Formula> weakOrSafetyCoSafety = new ArrayList<Formula>();
            for (Formula operand : disjunction.operands) {
                boolean isChainable;
                boolean isWeak = SyntacticFragments.DELTA_1.contains(operand);
                boolean isSafetyCoSafetyAndUnique = operand instanceof Formula.TemporalOperator && SyntacticFragments.isSafetyCoSafety(operand) && this.uniqueReference((Formula.TemporalOperator)operand);
                boolean bl = isChainable = SyntacticFragments.isFgSafety(operand) && this.uniqueReference((Formula.TemporalOperator)operand);
                if (isWeak || isSafetyCoSafetyAndUnique) {
                    weakOrSafetyCoSafety.add(operand);
                    continue;
                }
                if (isChainable) {
                    assert (operand instanceof FOperator);
                    operands.add(this.add(operand));
                    this.roundRobinCandidate.set((Integer)this.mapping.get((Object)operand.not()));
                    continue;
                }
                operands.add(operand.accept(this));
            }
            if (!weakOrSafetyCoSafety.isEmpty()) {
                operands.add(this.add(Disjunction.of(weakOrSafetyCoSafety)));
            }
            return PropositionalFormula.Disjunction.of(operands);
        }
    }

    private static final class NormalFormConverter
    extends PropositionalVisitor<Formula> {
        private NormalFormConverter() {
        }

        @Override
        protected Formula visit(Formula.TemporalOperator formula) {
            if (SyntacticFragments.isSafetyCoSafety(formula)) {
                return formula;
            }
            Formula.TemporalOperator formulaNot = (Formula.TemporalOperator)formula.not();
            if (SyntacticFragments.isSafetyCoSafety(formulaNot)) {
                return formula;
            }
            Formula normalForm1 = PushNextThroughPropositionalVisitor.apply(SimplifierRepository.SYNTACTIC_FIXPOINT.apply(NORMALISATION.apply(formula)));
            Formula normalForm2 = PushNextThroughPropositionalVisitor.apply(SimplifierRepository.SYNTACTIC_FIXPOINT.apply(DUAL_NORMALISATION.apply(formula)));
            if (normalForm1 instanceof Disjunction) {
                if (normalForm2 instanceof Disjunction && normalForm1.operands.size() < normalForm2.operands.size()) {
                    return normalForm1.accept(this);
                }
                return normalForm2.accept(this);
            }
            if (normalForm1 instanceof Conjunction) {
                if (normalForm2 instanceof Disjunction || normalForm2 instanceof Conjunction && normalForm1.operands.size() < normalForm2.operands.size()) {
                    return normalForm1.accept(this);
                }
                return normalForm2.accept(this);
            }
            if (normalForm1.operands.size() < normalForm2.operands.size()) {
                return normalForm1.accept(this);
            }
            return normalForm2.accept(this);
        }

        @Override
        public Formula visit(Literal literal) {
            return literal;
        }

        @Override
        public Formula visit(Biconditional biconditional) {
            return Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(operand -> operand.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(operand -> operand.accept(this)));
        }
    }

    private static final class CountingVisitor
    extends PropositionalVisitor<Void> {
        private final Map<Formula.TemporalOperator, Integer> referenceCounter = new HashMap<Formula.TemporalOperator, Integer>();

        private CountingVisitor() {
        }

        @Override
        protected Void visit(Formula.TemporalOperator formula) {
            if (this.referenceCounter.containsKey(formula)) {
                this.referenceCounter.put(formula, 2);
                return null;
            }
            Formula.TemporalOperator formulaNot = (Formula.TemporalOperator)formula.not();
            if (this.referenceCounter.containsKey(formulaNot)) {
                this.referenceCounter.put(formulaNot, 2);
                return null;
            }
            if (SyntacticFragments.isSafetyCoSafety(formula)) {
                this.referenceCounter.put(formula, 1);
                return null;
            }
            if (SyntacticFragments.isSafetyCoSafety(formulaNot)) {
                this.referenceCounter.put(formulaNot, 1);
                return null;
            }
            throw new AssertionError((Object)"should not be reachable.");
        }

        @Override
        public Void visit(Literal literal) {
            return null;
        }

        @Override
        public Void visit(Biconditional biconditional) {
            biconditional.operands.forEach(x -> x.accept(this));
            return null;
        }

        @Override
        public Void visit(BooleanConstant booleanConstant) {
            return null;
        }

        @Override
        public Void visit(Conjunction conjunction) {
            conjunction.operands.forEach(x -> x.accept(this));
            return null;
        }

        @Override
        public Void visit(Disjunction disjunction) {
            disjunction.operands.forEach(x -> x.accept(this));
            return null;
        }

        @Override
        public Void visit(Negation negation) {
            return negation.operand().accept(this);
        }
    }

    public static class Construction {
        private final DeterministicConstructions.SafetyCoSafety dbw;
        private final BreakpointStateRejectingClassifier classifier;
        private final EmersonLeiAcceptance acceptance;
        private final ImmutableBitSet roundRobinCandidates;
        private final Map<State, PropositionalFormula<Integer>> alphaCache = new HashMap<State, PropositionalFormula<Integer>>();
        private final Map<State, PropositionalFormula<Integer>> betaCache = new HashMap<State, PropositionalFormula<Integer>>();
        private final Map<PropositionalFormula<Integer>, ImmutableBitSet> notAlphaColoursCache = new HashMap<PropositionalFormula<Integer>, ImmutableBitSet>();
        private final AbstractMemoizingAutomaton<State, EmersonLeiAcceptance> automaton;

        private Construction(LabelledFormula formula, OptionalInt lookahead) {
            Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
            this.dbw = DeterministicConstructions.SafetyCoSafety.of(factories, BooleanConstant.TRUE, true, true);
            NormalFormConverter normalFormConstructor = new NormalFormConverter();
            Formula normalForm = (Formula)PropositionalSimplifier.INSTANCE.apply(formula.formula().accept(normalFormConstructor));
            CountingVisitor referenceCounterVisitor = new CountingVisitor();
            referenceCounterVisitor.apply(normalForm);
            referenceCounterVisitor.referenceCounter.entrySet().removeIf(e -> ((Integer)e.getValue()).equals(1));
            InitialStateConstructor initialStateFormulaConstructor = new InitialStateConstructor(this.dbw, referenceCounterVisitor.referenceCounter.keySet());
            PropositionalFormula initialStateFormula = (PropositionalFormula)initialStateFormulaConstructor.apply(normalForm);
            List<DeterministicConstructions.BreakpointStateRejecting> initialStates = initialStateFormulaConstructor.initialStates;
            this.classifier = new BreakpointStateRejectingClassifier(this.dbw, lookahead.stream().map(x -> Math.max(0, x / Math.max(1, initialStates.size()))).findAny());
            this.roundRobinCandidates = ImmutableBitSet.copyOf(initialStateFormulaConstructor.roundRobinCandidate);
            HashMap occurrences = new HashMap(initialStateFormula.countVariables());
            occurrences.values().removeIf(x -> x > 1);
            assert (occurrences.keySet().containsAll(this.roundRobinCandidates));
            HashMap<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap = new HashMap<Integer, DeterministicConstructions.BreakpointStateRejecting>(initialStates.size());
            int s = initialStates.size();
            for (int i = 0; i < s; ++i) {
                stateMap.put(i, initialStates.get(i));
            }
            State initialState = this.createState(initialStateFormula, stateMap, ImmutableBitSet.of(), new BitSet());
            this.acceptance = EmersonLeiAcceptance.of(initialState.stateFormula());
            this.automaton = new AbstractMemoizingAutomaton.EdgeTreeImplementation<State, EmersonLeiAcceptance>(this.dbw.atomicPropositions(), this.dbw.factory(), Set.of(initialState), this.acceptance){

                @Override
                protected MtBdd<Edge<State>> edgeTreeImpl(State state) {
                    Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap = state.stateMap();
                    ArrayList<Integer> keys = new ArrayList<Integer>(stateMap.size());
                    ArrayList<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>> values = new ArrayList<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>>(stateMap.size());
                    stateMap.forEach((key, value) -> {
                        keys.add((Integer)key);
                        values.add(dbw.edgeTree(value));
                    });
                    return this.edgeTreeImpl(state, keys, values, new HashMap<List<Edge<DeterministicConstructions.BreakpointStateRejecting>>, Edge<State>>(), 0);
                }

                private MtBdd<Edge<State>> edgeTreeImpl(State state, List<Integer> keys, List<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>> values, Map<List<Edge<DeterministicConstructions.BreakpointStateRejecting>>, Edge<State>> mapperCache, int leaves) {
                    int variable = this.nextVariable(values);
                    if (variable == Integer.MAX_VALUE) {
                        ArrayList<Edge> edges = new ArrayList<Edge>(values.size());
                        int s = keys.size();
                        for (int i = 0; i < s; ++i) {
                            MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>> value = values.get(i);
                            if (value instanceof MtBdd.Leaf) {
                                edges.add((Edge)Iterables.getOnlyElement(((MtBdd.Leaf)value).value));
                                continue;
                            }
                            assert (value == null);
                            edges.add(null);
                        }
                        Edge edge = mapperCache.computeIfAbsent(edges, y -> this.edge(state, keys, edges));
                        return ((State)edge.successor()).stateFormula().isFalse() ? MtBdd.of() : MtBdd.of(Set.of(edge));
                    }
                    ArrayList<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>> falseTrees = new ArrayList<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>>(values);
                    falseTrees.replaceAll(x -> this.descendFalseIf((MtBdd)x, variable));
                    int falseLeaves = this.countLeaves(falseTrees);
                    if (falseLeaves > leaves) {
                        this.shortCircuit(state, keys, falseTrees);
                    }
                    MtBdd<Edge<State>> falseCartesianProduct = this.edgeTreeImpl(state, keys, falseTrees, mapperCache, falseLeaves);
                    ArrayList<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>> trueTrees = new ArrayList<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>>(values);
                    trueTrees.replaceAll(x -> this.descendTrueIf((MtBdd)x, variable));
                    int trueLeaves = this.countLeaves(trueTrees);
                    if (trueLeaves > leaves) {
                        this.shortCircuit(state, keys, trueTrees);
                    }
                    MtBdd<Edge<State>> trueCartesianProduct = this.edgeTreeImpl(state, keys, trueTrees, mapperCache, trueLeaves);
                    return MtBdd.of(variable, trueCartesianProduct, falseCartesianProduct);
                }

                private int nextVariable(Collection<? extends MtBdd<?>> trees) {
                    int variable = Integer.MAX_VALUE;
                    for (MtBdd<?> tree : trees) {
                        variable = Math.min(variable, tree instanceof MtBdd.Node ? ((MtBdd.Node)tree).variable : Integer.MAX_VALUE);
                    }
                    return variable;
                }

                @Nullable
                private <E> MtBdd<E> descendFalseIf(@Nullable MtBdd<E> tree, int variable) {
                    if (tree instanceof MtBdd.Node && ((MtBdd.Node)tree).variable == variable) {
                        return ((MtBdd.Node)tree).falseChild;
                    }
                    return tree;
                }

                @Nullable
                private <E> MtBdd<E> descendTrueIf(@Nullable MtBdd<E> tree, int variable) {
                    if (tree instanceof MtBdd.Node && ((MtBdd.Node)tree).variable == variable) {
                        return ((MtBdd.Node)tree).trueChild;
                    }
                    return tree;
                }

                private void shortCircuit(State state, List<Integer> keys, List<MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>>> trees) {
                    ArrayList<Edge<DeterministicConstructions.BreakpointStateRejecting>> leaves = new ArrayList<Edge<DeterministicConstructions.BreakpointStateRejecting>>(trees.size());
                    for (MtBdd<Edge<DeterministicConstructions.BreakpointStateRejecting>> x : trees) {
                        leaves.add(x instanceof MtBdd.Leaf ? (Edge)Iterables.getOnlyElement(((MtBdd.Leaf)x).value) : null);
                    }
                    Map<Integer, DeterministicConstructions.BreakpointStateRejecting> successorMap = this.successorMap(keys, leaves, null);
                    NavigableMap<Integer, Classification> classification = classifier.classify(successorMap);
                    PropositionalFormula newStateFormula = state.stateFormula().substitute(index -> {
                        if (!classification.containsKey(index)) {
                            return PropositionalFormula.Variable.of(index);
                        }
                        switch ((Classification)((Object)((Object)classification.get(index)))) {
                            case TERMINAL_ACCEPTING: {
                                return PropositionalFormula.trueConstant();
                            }
                            case TERMINAL_REJECTING: {
                                return PropositionalFormula.falseConstant();
                            }
                        }
                        return PropositionalFormula.Variable.of(index);
                    });
                    BitSet remainingVariables = BitSet2.copyOf(newStateFormula.variables());
                    int s = keys.size();
                    for (int i = 0; i < s; ++i) {
                        if (!(trees.get(i) instanceof MtBdd.Node) || remainingVariables.get(keys.get(i))) continue;
                        trees.set(i, null);
                    }
                }

                private <E> int countLeaves(List<? extends MtBdd<E>> trees) {
                    int counter = 0;
                    for (MtBdd<E> tree : trees) {
                        if (!(tree instanceof MtBdd.Leaf)) continue;
                        ++counter;
                    }
                    return counter;
                }
            };
        }

        public AbstractMemoizingAutomaton<State, EmersonLeiAcceptance> automaton() {
            return this.automaton;
        }

        private ImmutableBitSet notAlphaColours(PropositionalFormula<Integer> alpha) {
            PropositionalFormula<Integer> acceptanceCondition = this.automaton.acceptance().booleanExpression();
            BitSet alphaColours = BitSet2.copyOf(alpha.variables());
            Map<Integer, Boolean> partialAssignment = PropositionalFormulaHelper.findPartialAssignment(acceptanceCondition, alpha);
            if (partialAssignment != null) {
                BitSet padding = new BitSet();
                partialAssignment.forEach(padding::set);
                PropositionalFormula simplifiedAcceptance = acceptanceCondition.substitute(x -> alphaColours.get((int)x) ? PropositionalFormula.Variable.of(x) : (padding.get((int)x) ? PropositionalFormula.trueConstant() : PropositionalFormula.falseConstant()));
                if (simplifiedAcceptance.equals(alpha)) {
                    return ImmutableBitSet.copyOf(padding);
                }
                PropositionalFormula<Integer> xor = PropositionalFormula.Negation.of(PropositionalFormula.Biconditional.of(alpha, simplifiedAcceptance));
                if (Solver.model(xor).isEmpty()) {
                    return ImmutableBitSet.copyOf(padding);
                }
            }
            throw new AssertionError((Object)"This should not have been reached, since alpha is computed from acceptanceCondition by substituting variables by constants.");
        }

        private Map<Integer, DeterministicConstructions.BreakpointStateRejecting> successorMap(List<Integer> keys, List<Edge<DeterministicConstructions.BreakpointStateRejecting>> edges, @Nullable BitSet colours) {
            HashMap<Integer, DeterministicConstructions.BreakpointStateRejecting> successorMap = new HashMap<Integer, DeterministicConstructions.BreakpointStateRejecting>(edges.size());
            int s = keys.size();
            for (int i = 0; i < s; ++i) {
                Integer key = keys.get(i);
                Edge<DeterministicConstructions.BreakpointStateRejecting> value = edges.get(i);
                if (value == null) continue;
                DeterministicConstructions.BreakpointStateRejecting oldValue = successorMap.put(key, value.successor());
                assert (oldValue == null);
                if (colours == null || !value.colours().contains(0)) continue;
                colours.set(key);
            }
            return successorMap;
        }

        private Edge<State> edge(State state, List<Integer> keys, List<Edge<DeterministicConstructions.BreakpointStateRejecting>> edges) {
            BitSet colours = new BitSet();
            Map<Integer, DeterministicConstructions.BreakpointStateRejecting> successorMap = this.successorMap(keys, edges, colours);
            State successor = this.createState(state.stateFormula(), successorMap, state.roundRobinCounters(), colours);
            PropositionalFormula<Integer> alpha = this.alphaCache.get(successor);
            colours.and(BitSet2.copyOf(alpha.variables()));
            this.notAlphaColoursCache.computeIfAbsent(alpha, this::notAlphaColours).copyInto(colours);
            return Edge.of(successor, colours);
        }

        private State createState(PropositionalFormula<Integer> stateFormula, Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap, ImmutableBitSet oldRoundRobinCounters, BitSet acceptingEdges) {
            Optional<Map.Entry> firstWeakIndex;
            assert (this.roundRobinCandidates.containsAll(oldRoundRobinCounters));
            NavigableMap<Integer, Classification> classification = this.classifier.classify(stateMap);
            PropositionalFormula<Integer> newStateFormula = stateFormula.substitute(index -> {
                if (!classification.containsKey(index)) {
                    return PropositionalFormula.Variable.of(index);
                }
                switch ((Classification)((Object)((Object)classification.get(index)))) {
                    case TERMINAL_ACCEPTING: {
                        return PropositionalFormula.trueConstant();
                    }
                    case TERMINAL_REJECTING: {
                        return PropositionalFormula.falseConstant();
                    }
                }
                return PropositionalFormula.Variable.of(index);
            });
            assert (stateMap.keySet().containsAll(newStateFormula.variables())) : "Short-circuiting failed";
            newStateFormula = this.pruneRedundantConjunctsAndDisjuncts(newStateFormula, stateMap);
            Set<Integer> remainingVariables = newStateFormula.variables();
            classification.keySet().retainAll(remainingVariables);
            stateMap.keySet().retainAll(remainingVariables);
            assert (!classification.containsValue((Object)Classification.TERMINAL_ACCEPTING));
            assert (!classification.containsValue((Object)Classification.TERMINAL_REJECTING));
            if (classification.containsValue((Object)Classification.TRANSIENT_SUSPENDED) || classification.containsValue((Object)Classification.TRANSIENT_NOT_SUSPENDED)) {
                int protectedIndex = classification.containsValue((Object)Classification.TRANSIENT_SUSPENDED) ? -1 : classification.entrySet().stream().filter(entry -> entry.getValue() == Classification.TRANSIENT_NOT_SUSPENDED).map(Map.Entry::getKey).findFirst().orElseThrow();
                stateMap.entrySet().forEach(entry -> {
                    if ((Integer)entry.getKey() != protectedIndex) {
                        entry.setValue(((DeterministicConstructions.BreakpointStateRejecting)entry.getValue()).suspend());
                    }
                });
                State state = State.of(newStateFormula, stateMap, ImmutableBitSet.of());
                this.alphaCache.put(state, PropositionalFormula.trueConstant());
                this.betaCache.put(state, PropositionalFormula.trueConstant());
                return state;
            }
            assert (!classification.containsValue((Object)Classification.TRANSIENT_SUSPENDED));
            assert (!classification.containsValue((Object)Classification.TRANSIENT_NOT_SUSPENDED));
            PropositionalFormula<Integer> alpha = newStateFormula.substitute(index -> {
                switch ((Classification)((Object)((Object)classification.get(index)))) {
                    case WEAK_ACCEPTING_SUSPENDED: {
                        return PropositionalFormula.trueConstant();
                    }
                    case WEAK_REJECTING_SUSPENDED: {
                        return PropositionalFormula.falseConstant();
                    }
                }
                return PropositionalFormula.Variable.of(index);
            });
            Set remainingVariables2 = alpha.variables();
            classification.forEach((key, value) -> {
                if (remainingVariables2.contains(key)) {
                    return;
                }
                stateMap.computeIfPresent((Integer)key, (x, y) -> y.suspend());
            });
            classification.keySet().retainAll(remainingVariables2);
            assert (!classification.containsValue((Object)Classification.WEAK_ACCEPTING_SUSPENDED));
            assert (!classification.containsValue((Object)Classification.WEAK_REJECTING_SUSPENDED));
            while (!(firstWeakIndex = classification.entrySet().stream().filter(entry -> entry.getValue() == Classification.WEAK_ACCEPTING_NOT_SUSPENDED || entry.getValue() == Classification.WEAK_REJECTING_NOT_SUSPENDED).findFirst()).isEmpty()) {
                int weakIndex = (Integer)firstWeakIndex.get().getKey();
                PropositionalFormula value2 = firstWeakIndex.get().getValue() == Classification.WEAK_ACCEPTING_NOT_SUSPENDED ? PropositionalFormula.trueConstant() : PropositionalFormula.falseConstant();
                alpha = alpha.substitute(i -> i == weakIndex ? value2 : PropositionalFormula.Variable.of(i));
                Set<Integer> remainingVariables3 = alpha.variables();
                classification.entrySet().forEach(entry -> {
                    if (remainingVariables3.contains(entry.getKey())) {
                        return;
                    }
                    if ((Integer)entry.getKey() == weakIndex) {
                        entry.setValue(Classification.NOT_SUSPENDABLE);
                        return;
                    }
                    assert (Set.of(Classification.WEAK_ACCEPTING_NOT_SUSPENDED, Classification.WEAK_REJECTING_NOT_SUSPENDED, Classification.SUSPENDABLE, Classification.NOT_SUSPENDABLE).contains(entry.getValue()));
                    if (entry.getValue() != Classification.NOT_SUSPENDABLE) {
                        entry.setValue(Classification.SUSPENDABLE);
                        stateMap.computeIfPresent((Integer)entry.getKey(), (x, y) -> y.suspend());
                    }
                });
            }
            assert (Set.of(Classification.SUSPENDABLE, Classification.NOT_SUSPENDABLE).containsAll(classification.values()));
            assert (classification.keySet().containsAll(alpha.variables()));
            BitSet newRoundRobinCounters = new BitSet();
            List<ImmutableBitSet> roundRobinChains = this.roundRobinSuspension(alpha, stateMap, acceptingEdges, oldRoundRobinCounters, newRoundRobinCounters);
            alpha = alpha.substitute(x -> {
                ImmutableBitSet roundRobinChain = (ImmutableBitSet)Iterables.getOnlyElement((Iterable)roundRobinChains.stream().filter(chain -> chain.contains(x)).collect(Collectors.toList()), null);
                return roundRobinChain == null ? PropositionalFormula.Variable.of(x) : PropositionalFormula.Variable.of(roundRobinChain.first().orElseThrow());
            });
            State state = State.of(newStateFormula, stateMap, newRoundRobinCounters);
            PropositionalFormula<Integer> oldAlpha = this.alphaCache.put(state, alpha);
            assert (oldAlpha == null || alpha.equals(oldAlpha));
            return state;
        }

        private NavigableSet<Integer> roundRobinChain(PropositionalFormula.Conjunction<Integer> conjunction) {
            TreeSet<Integer> roundRobinChain = new TreeSet<Integer>();
            for (PropositionalFormula conjunct : conjunction.conjuncts) {
                int variable;
                if (!(conjunct instanceof PropositionalFormula.Variable) || !this.roundRobinCandidates.contains(variable = ((Integer)((PropositionalFormula.Variable)conjunct).variable).intValue())) continue;
                roundRobinChain.add(variable);
            }
            return roundRobinChain;
        }

        private NavigableSet<Integer> roundRobinChain(PropositionalFormula.Disjunction<Integer> disjunction) {
            TreeSet<Integer> roundRobinChain = new TreeSet<Integer>();
            for (PropositionalFormula disjunct : disjunction.disjuncts) {
                int variable;
                if (!(disjunct instanceof PropositionalFormula.Negation)) continue;
                PropositionalFormula.Negation negation = (PropositionalFormula.Negation)disjunct;
                if (!(negation.operand instanceof PropositionalFormula.Variable) || !this.roundRobinCandidates.contains(variable = ((Integer)((PropositionalFormula.Variable)negation.operand).variable).intValue())) continue;
                roundRobinChain.add(variable);
            }
            return roundRobinChain;
        }

        private NavigableSet<Integer> roundRobinChain(PropositionalFormula<Integer> formula) {
            if (formula instanceof PropositionalFormula.Variable || formula instanceof PropositionalFormula.Negation || formula instanceof PropositionalFormula.Biconditional) {
                return new TreeSet<Integer>();
            }
            if (formula instanceof PropositionalFormula.Conjunction) {
                return this.roundRobinChain((PropositionalFormula.Conjunction)formula);
            }
            return this.roundRobinChain((PropositionalFormula.Disjunction)formula);
        }

        private List<ImmutableBitSet> roundRobinSuspension(PropositionalFormula<Integer> alpha, Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap, BitSet acceptingEdges, ImmutableBitSet oldRoundRobinCounters, BitSet newRoundRobinCounters) {
            ArrayList<ImmutableBitSet> roundRobinChains = new ArrayList<ImmutableBitSet>();
            NavigableSet<Integer> roundRobinChain = this.roundRobinChain(alpha);
            if (roundRobinChain.size() >= 2) {
                int n;
                ImmutableBitSet intersection = oldRoundRobinCounters.intersection(roundRobinChain);
                assert (intersection.size() < 2);
                int n2 = intersection.first().orElse((Integer)roundRobinChain.first());
                boolean fullCircle = true;
                Iterator<Object> iterator = Iterables.concat(roundRobinChain.tailSet(n2, true), roundRobinChain.headSet(n2, false)).iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    if (acceptingEdges.get(n3)) continue;
                    int n4 = n3;
                    fullCircle = false;
                    break;
                }
                if (fullCircle) {
                    n = (Integer)roundRobinChain.first();
                }
                for (Map.Entry entry : stateMap.entrySet()) {
                    if (!roundRobinChain.contains(entry.getKey()) || (Integer)entry.getKey() == n) continue;
                    entry.setValue(((DeterministicConstructions.BreakpointStateRejecting)entry.getValue()).suspend());
                }
                newRoundRobinCounters.set(n);
                roundRobinChains.add(ImmutableBitSet.copyOf(roundRobinChain));
            }
            if (alpha instanceof PropositionalFormula.Biconditional) {
                PropositionalFormula.Biconditional castedAlpha = (PropositionalFormula.Biconditional)alpha;
                roundRobinChains.addAll(this.roundRobinSuspension(castedAlpha.leftOperand, stateMap, acceptingEdges, oldRoundRobinCounters, newRoundRobinCounters));
                roundRobinChains.addAll(this.roundRobinSuspension(castedAlpha.rightOperand, stateMap, acceptingEdges, oldRoundRobinCounters, newRoundRobinCounters));
            } else if (alpha instanceof PropositionalFormula.Conjunction) {
                for (PropositionalFormula<Integer> propositionalFormula : ((PropositionalFormula.Conjunction)alpha).conjuncts) {
                    roundRobinChains.addAll(this.roundRobinSuspension(propositionalFormula, stateMap, acceptingEdges, oldRoundRobinCounters, newRoundRobinCounters));
                }
            } else if (alpha instanceof PropositionalFormula.Disjunction) {
                for (PropositionalFormula<Integer> propositionalFormula : ((PropositionalFormula.Disjunction)alpha).disjuncts) {
                    roundRobinChains.addAll(this.roundRobinSuspension(propositionalFormula, stateMap, acceptingEdges, oldRoundRobinCounters, newRoundRobinCounters));
                }
            } else assert (alpha instanceof PropositionalFormula.Negation || alpha instanceof PropositionalFormula.Variable);
            return roundRobinChains;
        }

        private PropositionalFormula<Integer> pruneRedundantConjunctsAndDisjuncts(PropositionalFormula<Integer> stateFormula, Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap) {
            if (stateFormula instanceof PropositionalFormula.Variable) {
                return stateFormula;
            }
            if (stateFormula instanceof PropositionalFormula.Negation) {
                return PropositionalFormula.Negation.of(this.pruneRedundantConjunctsAndDisjuncts(((PropositionalFormula.Negation)stateFormula).operand, stateMap));
            }
            if (stateFormula instanceof PropositionalFormula.Biconditional) {
                PropositionalFormula.Biconditional castedStateFormula = (PropositionalFormula.Biconditional)stateFormula;
                if (Construction.isVariableOrNegationOfVariable(castedStateFormula.leftOperand) && Construction.isVariableOrNegationOfVariable(castedStateFormula.rightOperand)) {
                    EquivalenceClass rightLanguage;
                    EquivalenceClass leftLanguage = Construction.language(castedStateFormula.leftOperand, stateMap);
                    if (leftLanguage.equals(rightLanguage = Construction.language(castedStateFormula.rightOperand, stateMap))) {
                        return PropositionalFormula.trueConstant();
                    }
                    if (leftLanguage.equals(rightLanguage.not())) {
                        return PropositionalFormula.falseConstant();
                    }
                }
                return PropositionalFormula.Biconditional.of(this.pruneRedundantConjunctsAndDisjuncts(castedStateFormula.leftOperand, stateMap), this.pruneRedundantConjunctsAndDisjuncts(castedStateFormula.rightOperand, stateMap));
            }
            if (stateFormula instanceof PropositionalFormula.Conjunction) {
                return PropositionalFormula.Conjunction.of(Collections3.maximalElements(((PropositionalFormula.Conjunction)stateFormula).conjuncts.stream().map(x -> this.pruneRedundantConjunctsAndDisjuncts((PropositionalFormula<Integer>)x, stateMap)).collect(Collectors.toList()), (x, y) -> {
                    if (!Construction.isVariableOrNegationOfVariable(x) || !Construction.isVariableOrNegationOfVariable(y)) {
                        return false;
                    }
                    EquivalenceClass xLanguage = Construction.language(x, stateMap);
                    EquivalenceClass yLanguage = Construction.language(y, stateMap);
                    if (Collections.disjoint(xLanguage.temporalOperators(), yLanguage.temporalOperators())) {
                        return false;
                    }
                    return yLanguage.implies(xLanguage);
                }));
            }
            assert (stateFormula instanceof PropositionalFormula.Disjunction);
            return PropositionalFormula.Disjunction.of(Collections3.maximalElements(((PropositionalFormula.Disjunction)stateFormula).disjuncts.stream().map(x -> this.pruneRedundantConjunctsAndDisjuncts((PropositionalFormula<Integer>)x, stateMap)).collect(Collectors.toList()), (x, y) -> {
                if (!Construction.isVariableOrNegationOfVariable(x) || !Construction.isVariableOrNegationOfVariable(y)) {
                    return false;
                }
                EquivalenceClass xLanguage = Construction.language(x, stateMap);
                EquivalenceClass yLanguage = Construction.language(y, stateMap);
                if (Collections.disjoint(xLanguage.temporalOperators(), yLanguage.temporalOperators())) {
                    return false;
                }
                return xLanguage.implies(yLanguage);
            }));
        }

        private static boolean isVariableOrNegationOfVariable(PropositionalFormula<?> formula) {
            return formula instanceof PropositionalFormula.Variable || formula instanceof PropositionalFormula.Negation && ((PropositionalFormula.Negation)formula).operand instanceof PropositionalFormula.Variable;
        }

        private static EquivalenceClass language(PropositionalFormula<Integer> stateFormula, Map<Integer, ? extends DeterministicConstructions.BreakpointStateRejecting> stateMap) {
            assert (Construction.isVariableOrNegationOfVariable(stateFormula));
            if (stateFormula instanceof PropositionalFormula.Variable) {
                int index = (Integer)((PropositionalFormula.Variable)stateFormula).variable;
                return stateMap.get(index).all();
            }
            assert (stateFormula instanceof PropositionalFormula.Negation);
            PropositionalFormula operand = ((PropositionalFormula.Negation)stateFormula).operand;
            assert (operand instanceof PropositionalFormula.Variable);
            int index = (Integer)((PropositionalFormula.Variable)operand).variable;
            return stateMap.get(index).all().not();
        }

        public PropositionalFormula<Integer> alpha(State state) {
            return this.alphaCache.get(state);
        }

        public PropositionalFormula<Integer> beta(State state) {
            return this.betaCache.computeIfAbsent(state, this::computeBeta);
        }

        private PropositionalFormula<Integer> computeBeta(State state) {
            Set<Integer> variables = this.alpha(state).variables();
            ArrayList facts = new ArrayList();
            for (int var1 : variables) {
                for (int var2 : variables) {
                    if (var1 == var2) continue;
                    DeterministicConstructions.BreakpointStateRejecting state1 = state.stateMap().get(var1);
                    DeterministicConstructions.BreakpointStateRejecting state2 = state.stateMap().get(var2);
                    EquivalenceClass clazz1 = state1.all();
                    EquivalenceClass clazz2 = state2.all();
                    if (Collections.disjoint(clazz1.temporalOperators(), clazz2.temporalOperators()) || !clazz1.implies(clazz2)) continue;
                    PropositionalFormula<Integer> neg1 = PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(var1));
                    PropositionalFormula.Variable<Integer> pos2 = PropositionalFormula.Variable.of(var2);
                    facts.add(PropositionalFormula.Disjunction.of(new PropositionalFormula[]{neg1, pos2}));
                }
            }
            return PropositionalFormula.Conjunction.of(facts);
        }
    }

    private static final class RemoveNegation
    extends PropositionalVisitor<Formula> {
        private static final RemoveNegation INSTANCE = new RemoveNegation();

        private RemoveNegation() {
        }

        public static LabelledFormula apply(LabelledFormula labelledFormula) {
            return labelledFormula.wrap(labelledFormula.formula().accept(INSTANCE));
        }

        @Override
        protected Formula visit(Formula.TemporalOperator formula) {
            return formula.nnf();
        }

        @Override
        public Formula visit(Literal literal) {
            return literal;
        }

        @Override
        public Formula visit(Biconditional biconditional) {
            Formula leftOperand = biconditional.leftOperand().accept(this);
            Formula rightOperand = biconditional.rightOperand().accept(this);
            if (SyntacticFragments.DELTA_1.contains(leftOperand) && SyntacticFragments.DELTA_1.contains(rightOperand)) {
                Formula nnfFormula = Biconditional.of(leftOperand, rightOperand).nnf();
                assert (SyntacticFragments.DELTA_1.contains(nnfFormula));
                return nnfFormula;
            }
            return Biconditional.of(leftOperand, rightOperand);
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Negation negation) {
            return negation.operand().not().accept(this);
        }
    }
}

