/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.SingletonAutomaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.translations.BlockingElements;
import owl.translations.ltl2dpa.AsymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricLDBAConstruction;
import owl.translations.ltl2ldba.AsymmetricProductState;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;

final class AsymmetricDPAConstruction {
    private static final AsymmetricLDBAConstruction<BuchiAcceptance> LDBA_CONSTRUCTION = AsymmetricLDBAConstruction.of(BuchiAcceptance.class);

    AsymmetricDPAConstruction() {
    }

    Automaton<AsymmetricRankingState, ParityAcceptance> of(LabelledFormula labelledFormula, boolean complete) {
        LabelledFormula nnfLabelledFormula = labelledFormula.nnf();
        AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba = LDBA_CONSTRUCTION.apply(nnfLabelledFormula);
        List<String> atomicPropositions = ldba.acceptingComponent().atomicPropositions();
        if (ldba.initialComponent().initialStates().isEmpty()) {
            ParityAcceptance acceptance = new ParityAcceptance(3, ParityAcceptance.Parity.MIN_ODD);
            EquivalenceClassFactory eqFactory = FactorySupplier.defaultSupplier().getEquivalenceClassFactory(atomicPropositions);
            return complete ? SingletonAutomaton.of(atomicPropositions, AsymmetricRankingState.of(eqFactory.of(false)), acceptance, acceptance.rejectingSet().orElseThrow()) : EmptyAutomaton.of(atomicPropositions, acceptance);
        }
        final Builder builder = new Builder(nnfLabelledFormula.formula(), ldba, complete);
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<AsymmetricRankingState, ParityAcceptance>(builder.ldba.acceptingComponent().atomicPropositions(), builder.ldba.factory(), Set.of(builder.initialState), builder.acceptance){
            @Nullable
            private Builder internalBuilder;
            {
                super(atomicPropositions, factory, initialStates, acceptance);
                this.internalBuilder = builder;
            }

            @Override
            protected MtBdd<Edge<AsymmetricRankingState>> edgeTreeImpl(AsymmetricRankingState state) {
                return this.internalBuilder.edgeTree(state);
            }

            @Override
            protected void explorationCompleted() {
                this.internalBuilder = null;
            }
        };
    }

    private static final class Builder {
        private final ParityAcceptance acceptance;
        private final AsymmetricRankingState initialState;
        private final EquivalenceClassFactory factory;
        private final List<Set<EquivalenceClass>> initialComponentSccs;
        private final AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba;
        private final Set<Formula.TemporalOperator> blockingSafetyOperators;
        private final Map<EquivalenceClass, Boolean> blockedByTransient = new HashMap<EquivalenceClass, Boolean>();
        private final Map<EquivalenceClass, Boolean> blockedBySafety = new HashMap<EquivalenceClass, Boolean>();
        @Nullable
        private final Edge<AsymmetricRankingState> rejectingEdge;

        private Builder(Formula formula, AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, BuchiAcceptance, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> ldba, boolean complete) {
            this.ldba = ldba;
            this.initialComponentSccs = SccDecomposition.of(ldba.initialComponent()).sccs();
            this.acceptance = new ParityAcceptance(2 * (ldba.acceptingComponent().states().size() + 1), ParityAcceptance.Parity.MIN_ODD);
            EquivalenceClass ldbaInitialState = ldba.initialComponent().initialState();
            this.factory = ldbaInitialState.factory();
            this.blockingSafetyOperators = BlockingElements.blockingSafetyFormulas(this.factory.of(formula));
            this.initialState = this.edge(ldbaInitialState, List.of(), -1).successor();
            this.rejectingEdge = complete ? Edge.of(AsymmetricRankingState.of(this.factory.of(false)), this.acceptance.rejectingSet().orElseThrow()) : null;
        }

        private boolean isBlockedByTransient(EquivalenceClass state) {
            return this.blockedByTransient.computeIfAbsent(state, BlockingElements::isBlockedByTransient);
        }

        private boolean isBlockedBySafety(EquivalenceClass state) {
            return this.blockedBySafety.computeIfAbsent(state, x -> !Collections.disjoint(x.temporalOperators(), this.blockingSafetyOperators) || BlockingElements.isBlockedBySafety(x));
        }

        private Edge<AsymmetricRankingState> edge(EquivalenceClass successor, List<Edge<AsymmetricProductState>> rankingEdges, int previousSafetyProgress) {
            int safetyProgress;
            if (this.isBlockedByTransient(successor) || this.isBlockedBySafety(successor)) {
                return Edge.of(AsymmetricRankingState.of(successor), 1);
            }
            HashSet<AsymmetricEvaluatedFixpoints> availableFixpoints = new HashSet<AsymmetricEvaluatedFixpoints>();
            List partitionedFixpoints = List.of(new TreeMap(), new TreeMap(), new TreeMap(), new TreeMap());
            for (AsymmetricProductState jumpTarget : this.ldba.stateAnnotation().apply(successor)) {
                AsymmetricEvaluatedFixpoints fixpoints = jumpTarget.evaluatedFixpoints;
                boolean changed = availableFixpoints.add(fixpoints);
                assert (changed) : "Detected two jumps to the same component." + this.ldba.stateAnnotation().apply(successor);
                if (fixpoints.isSafety()) {
                    if (SyntacticFragments.isSafety(jumpTarget.language())) {
                        ((NavigableMap)partitionedFixpoints.get(3)).put(fixpoints, jumpTarget);
                        continue;
                    }
                    ((NavigableMap)partitionedFixpoints.get(2)).put(fixpoints, jumpTarget);
                    continue;
                }
                if (fixpoints.isLiveness()) {
                    ((NavigableMap)partitionedFixpoints.get(0)).put(fixpoints, jumpTarget);
                    continue;
                }
                ((NavigableMap)partitionedFixpoints.get(1)).put(fixpoints, jumpTarget);
            }
            ArrayList<AsymmetricProductState> ranking = new ArrayList<AsymmetricProductState>(rankingEdges.size());
            int rankingColor = 2 * rankingEdges.size();
            EquivalenceClass rankingLanguage = this.factory.of(BooleanConstant.FALSE);
            Iterator<Edge<AsymmetricProductState>> iterator = rankingEdges.iterator();
            while (iterator.hasNext()) {
                Edge<AsymmetricProductState> rankingEdge = iterator.next();
                if (rankingEdge == null || !this.ldba.acceptingComponent().states().contains(rankingEdge.successor())) {
                    rankingColor = Math.min(2 * ranking.size(), rankingColor);
                    continue;
                }
                AsymmetricProductState rankingSuccessor = rankingEdge.successor();
                AsymmetricEvaluatedFixpoints fixpoints = Objects.requireNonNull(rankingSuccessor.evaluatedFixpoints);
                EquivalenceClass successorLanguage = rankingSuccessor.language();
                if (!availableFixpoints.contains(fixpoints) || successorLanguage.implies(rankingLanguage)) {
                    rankingColor = Math.min(2 * ranking.size(), rankingColor);
                    continue;
                }
                if (rankingEdge.colours().contains(0)) {
                    rankingColor = Math.min(2 * ranking.size() + 1, rankingColor);
                }
                ranking.add(rankingSuccessor);
                rankingLanguage = rankingLanguage.or(successorLanguage);
                if (iterator.hasNext() || !((NavigableMap)partitionedFixpoints.get(3)).containsKey(rankingSuccessor.evaluatedFixpoints) || this.ldba.annotation().headSet(fixpoints).size() != previousSafetyProgress) continue;
                rankingLanguage = this.factory.of(BooleanConstant.TRUE);
            }
            if (rankingLanguage.isTrue()) {
                safetyProgress = ranking.isEmpty() ? -1 : previousSafetyProgress;
            } else {
                Iterable<Object> orderedSafetyStates;
                for (AsymmetricProductState jumpTarget : Iterables.concat(((NavigableMap)partitionedFixpoints.get(0)).values(), ((NavigableMap)partitionedFixpoints.get(1)).values(), ((NavigableMap)partitionedFixpoints.get(2)).values())) {
                    EquivalenceClass jumpTargetLanguage = jumpTarget.language();
                    if (jumpTargetLanguage.implies(rankingLanguage) || !this.ldba.acceptingComponent().states().contains(jumpTarget)) continue;
                    ranking.add(jumpTarget);
                    rankingLanguage = rankingLanguage.or(jumpTargetLanguage);
                }
                NavigableMap availableSafetyFixpoints = partitionedFixpoints.get(3);
                if (previousSafetyProgress >= 0) {
                    AsymmetricEvaluatedFixpoints previousSafetyFixpoints = (AsymmetricEvaluatedFixpoints)Iterables.get((Iterable)this.ldba.annotation(), (int)previousSafetyProgress);
                    orderedSafetyStates = Iterables.concat(availableSafetyFixpoints.tailMap(previousSafetyFixpoints, false).values(), availableSafetyFixpoints.headMap(previousSafetyFixpoints, true).values());
                } else {
                    orderedSafetyStates = availableSafetyFixpoints.values();
                }
                safetyProgress = -1;
                for (AsymmetricProductState safetyState : orderedSafetyStates) {
                    if (safetyState.language().implies(rankingLanguage) || !this.ldba.acceptingComponent().states().contains(safetyState)) continue;
                    ranking.add(safetyState);
                    safetyProgress = this.ldba.annotation().headSet(safetyState.evaluatedFixpoints).size();
                    break;
                }
            }
            assert (rankingColor < this.acceptance.acceptanceSets());
            return Edge.of(AsymmetricRankingState.of(successor, ranking, safetyProgress), rankingColor);
        }

        private MtBdd<Edge<AsymmetricRankingState>> edgeTree(AsymmetricRankingState macroState) {
            if (macroState.state().isFalse() && this.rejectingEdge != null) {
                return MtBdd.of(Set.of(this.rejectingEdge));
            }
            MtBdd successorTree = this.ldba.initialComponent().edgeTree(macroState.state()).map(edges -> {
                if (edges.isEmpty() && this.rejectingEdge != null) {
                    return Set.of(this.rejectingEdge.successor().state());
                }
                return Edges.successors(edges);
            });
            MtBdd rankingEdgeTree = MtBddOperations.cartesianProductWithNull(macroState.ranking().stream().map(state -> this.ldba.acceptingComponent().edgeTree((AsymmetricProductState)state)).collect(Collectors.toList()));
            return MtBddOperations.cartesianProduct(successorTree, rankingEdgeTree, (successor, rankingEdges) -> {
                if (successor.isFalse()) {
                    return Objects.requireNonNull(this.rejectingEdge);
                }
                if (this.initialComponentSccs.stream().anyMatch(x -> x.contains(macroState.state()) && !x.contains(successor))) {
                    return this.edge((EquivalenceClass)successor, List.of(), -1).withoutAcceptance();
                }
                return this.edge((EquivalenceClass)successor, (List<Edge<AsymmetricProductState>>)rankingEdges, macroState.safetyIndex());
            });
        }
    }
}

