/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import owl.automaton.Automaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.transformer.ZielonkaTreeTransformations;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;
import owl.ltl.LabelledFormula;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.ltl2dela.NormalformDELAConstruction;

public final class NormalformDPAConstruction
implements Function<LabelledFormula, Automaton<ZielonkaTreeTransformations.ZielonkaState<NormalformDELAConstruction.State>, ParityAcceptance>> {
    private final NormalformDELAConstruction normalformDELAConstruction;
    private final OptionalInt lookahead;

    public NormalformDPAConstruction(OptionalInt lookahead) {
        this.lookahead = lookahead;
        this.normalformDELAConstruction = new NormalformDELAConstruction(lookahead);
    }

    @Override
    public ZielonkaTreeTransformations.AutomatonWithZielonkaTreeLookup<ZielonkaTreeTransformations.ZielonkaState<NormalformDELAConstruction.State>, ParityAcceptance> apply(LabelledFormula formula) {
        NormalformDELAConstruction.Construction delwConstruction = this.normalformDELAConstruction.applyConstruction(formula);
        return ZielonkaTreeTransformations.transform(delwConstruction.automaton(), this.lookahead, NormalformDELAConstruction.State::inDifferentSccs, delwConstruction::alpha, delwConstruction::beta);
    }

    private static double scaleLevel(int level) {
        assert (0 <= level);
        return Math.pow(2.0, -(level + 1));
    }

    private static double approximateTrueness(PropositionalFormula<Integer> formula, Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap, BitSet processedStates) {
        if (formula instanceof PropositionalFormula.Variable) {
            int index = (Integer)((PropositionalFormula.Variable)formula).variable;
            if (processedStates.get(index)) {
                return 0.5;
            }
            return stateMap.get(index).all().trueness();
        }
        if (formula instanceof PropositionalFormula.Negation) {
            return 1.0 - NormalformDPAConstruction.approximateTrueness(((PropositionalFormula.Negation)formula).operand, stateMap, processedStates);
        }
        if (formula instanceof PropositionalFormula.Biconditional) {
            PropositionalFormula.Biconditional castedFormula = (PropositionalFormula.Biconditional)formula;
            return Math.abs(NormalformDPAConstruction.approximateTrueness(castedFormula.leftOperand, stateMap, processedStates) - NormalformDPAConstruction.approximateTrueness(castedFormula.rightOperand, stateMap, processedStates));
        }
        if (formula instanceof PropositionalFormula.Conjunction) {
            PropositionalFormula.Conjunction castedFormula = (PropositionalFormula.Conjunction)formula;
            double trueness = 1.0;
            for (PropositionalFormula<Integer> propositionalFormula : castedFormula.conjuncts) {
                trueness = Math.min(trueness, NormalformDPAConstruction.approximateTrueness(propositionalFormula, stateMap, processedStates));
            }
            return trueness;
        }
        assert (formula instanceof PropositionalFormula.Disjunction);
        PropositionalFormula.Disjunction castedFormula = (PropositionalFormula.Disjunction)formula;
        double trueness = 0.0;
        for (PropositionalFormula<Integer> propositionalFormula : castedFormula.disjuncts) {
            trueness = Math.max(trueness, NormalformDPAConstruction.approximateTrueness(propositionalFormula, stateMap, processedStates));
        }
        return trueness;
    }

    public static ToDoubleFunction<Edge<ZielonkaTreeTransformations.ZielonkaState<NormalformDELAConstruction.State>>> scoringFunction(ZielonkaTreeTransformations.AutomatonWithZielonkaTreeLookup<ZielonkaTreeTransformations.ZielonkaState<NormalformDELAConstruction.State>, ParityAcceptance> automaton) {
        return edge -> {
            ZielonkaTreeTransformations.ZielonkaState successor = (ZielonkaTreeTransformations.ZielonkaState)edge.successor();
            ZielonkaTreeTransformations.ZielonkaTree tree = automaton.lookup(successor);
            ArrayList<ImmutableBitSet> colours = new ArrayList<ImmutableBitSet>();
            ImmutableIntArray path = successor.path().indices();
            ZielonkaTreeTransformations.ZielonkaTree node = tree;
            int s = path.length();
            for (int i = 0; i <= s; ++i) {
                colours.add(node.colours());
                if (i >= s) continue;
                node = node.children().get(path.get(i));
            }
            if (colours.size() <= 1) {
                colours.clear();
            }
            double score = 0.0;
            BitSet processedStates = new BitSet();
            int s2 = colours.size();
            for (int i = 0; i < s2 - 1; ++i) {
                SortedSet<Integer> activeColours = BitSet2.asSet(((ImmutableBitSet)colours.get(i)).copyInto(new BitSet()));
                activeColours.removeAll((Collection)colours.get(i + 1));
                double nextBuechiEvent = 0.0;
                Iterator iterator = activeColours.iterator();
                while (iterator.hasNext()) {
                    int activeColour = (Integer)iterator.next();
                    DeterministicConstructions.BreakpointStateRejecting dbwState = ((NormalformDELAConstruction.State)successor.state()).stateMap().get(activeColour);
                    processedStates.set(activeColour);
                    if (dbwState.isSuspended()) continue;
                    nextBuechiEvent = Math.max(nextBuechiEvent, dbwState.rejecting().trueness());
                }
                score += NormalformDPAConstruction.scaleLevel(i) * nextBuechiEvent;
            }
            double trueness = NormalformDPAConstruction.approximateTrueness(((NormalformDELAConstruction.State)successor.state()).stateFormula(), ((NormalformDELAConstruction.State)successor.state()).stateMap(), processedStates);
            double nextEvent = 2.0 * Math.abs(trueness - 0.5);
            assert (colours.size() != 1);
            double d = score = colours.isEmpty() ? nextEvent : score + NormalformDPAConstruction.scaleLevel(colours.size() - 1) * nextEvent;
            assert (0.0 <= score);
            assert (score <= 1.1);
            return score;
        };
    }
}

