/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.rewriter.SimplifierRepository;
import owl.translations.ltl2dra.AutoValue_AbstractNormalformDRAConstruction_Sigma2Pi2Pair;
import owl.translations.mastertheorem.Normalisation;

class AbstractNormalformDRAConstruction {
    private static final Normalisation NORMALISATION = Normalisation.of(Normalisation.NormalisationMethod.SE20_SIGMA_2_AND_GF_SIGMA_1, false);
    private static final Normalisation DUAL_NORMALISATION = Normalisation.of(Normalisation.NormalisationMethod.SE20_PI_2_AND_FG_PI_1, false);
    private final boolean useDualConstruction;

    AbstractNormalformDRAConstruction(boolean useDualConstruction) {
        this.useDualConstruction = useDualConstruction;
    }

    /*
     * WARNING - void declaration
     */
    List<Sigma2Pi2Pair> group(LabelledFormula labelledFormula) {
        void var6_10;
        ArrayList<Formula> delta2disjuncts = new ArrayList<Formula>();
        for (Set<Formula> clause : NormalForms.toDnf(labelledFormula.formula())) {
            Formula conjunction = Conjunction.of(clause);
            if (SyntacticFragments.DELTA_2.contains(conjunction)) {
                delta2disjuncts.add(conjunction);
                continue;
            }
            Formula formula2 = NormalForms.toDnfFormula(NORMALISATION.apply(conjunction));
            if (!this.useDualConstruction) {
                delta2disjuncts.add(formula2);
                continue;
            }
            Formula dualNormalForm = NormalForms.toDnfFormula(DUAL_NORMALISATION.apply(conjunction));
            Predicate<Formula> relevantSubformulas = formula -> formula instanceof Formula.TemporalOperator && !(formula instanceof XOperator) && SyntacticFragments.FormulaClass.classify(formula).level() == 2;
            if (formula2.subformulas(relevantSubformulas).size() <= dualNormalForm.subformulas(relevantSubformulas).size()) {
                delta2disjuncts.add(formula2);
                continue;
            }
            delta2disjuncts.add(dualNormalForm);
        }
        Formula delta2Formula = Disjunction.of(delta2disjuncts);
        HashBasedTable table = HashBasedTable.create();
        if (delta2Formula.anyMatch(x -> x instanceof XOperator && SyntacticFragments.FormulaClass.classify(x).equals(SyntacticFragments.DELTA_2))) {
            delta2Formula = delta2Formula.substitute(x -> {
                if (x instanceof XOperator && SyntacticFragments.FormulaClass.classify(x).equals(SyntacticFragments.DELTA_2)) {
                    return SimplifierRepository.PUSH_DOWN_X.apply((Formula)x);
                }
                return x;
            });
        }
        for (Set set : NormalForms.toDnf(delta2Formula)) {
            if (set.stream().anyMatch(formula -> clause.contains(formula.not()))) continue;
            HashSet<Formula> delta1 = new HashSet<Formula>();
            HashSet<Formula.TemporalOperator> sigma2 = new HashSet<Formula.TemporalOperator>();
            HashSet<Formula.TemporalOperator> pi2 = new HashSet<Formula.TemporalOperator>();
            for (Formula formula2 : set) {
                SyntacticFragments.FormulaClass formulaClass = SyntacticFragments.FormulaClass.classify(formula2);
                if (formulaClass.level() <= 1) {
                    delta1.add(formula2);
                    continue;
                }
                assert (formulaClass.level() == 2);
                assert (formulaClass.type() != SyntacticFragments.Type.DELTA);
                assert (formula2 instanceof Formula.TemporalOperator);
                if (formulaClass.type() == SyntacticFragments.Type.SIGMA) {
                    sigma2.add((Formula.TemporalOperator)formula2);
                    continue;
                }
                assert (formulaClass.type() == SyntacticFragments.Type.PI) : formula2;
                pi2.add((Formula.TemporalOperator)formula2);
            }
            Formula oldDelta1 = (Formula)table.get(sigma2, pi2);
            if (oldDelta1 == null) {
                oldDelta1 = BooleanConstant.FALSE;
            }
            table.put(sigma2, pi2, (Object)Disjunction.of(oldDelta1, Conjunction.of(delta1)));
        }
        Formula globalSigma2 = BooleanConstant.FALSE;
        BooleanConstant booleanConstant = BooleanConstant.FALSE;
        Formula globalDelta1 = BooleanConstant.FALSE;
        List<String> atomicPropositions = labelledFormula.atomicPropositions();
        ArrayList<Sigma2Pi2Pair> pairs = new ArrayList<Sigma2Pi2Pair>();
        for (Table.Cell cell : table.cellSet()) {
            Set sigma2 = Objects.requireNonNull((Set)cell.getRowKey());
            Set pi2 = Objects.requireNonNull((Set)cell.getColumnKey());
            Formula delta1 = Objects.requireNonNull((Formula)cell.getValue());
            if (pi2.isEmpty() && sigma2.isEmpty()) {
                assert (globalDelta1.equals(BooleanConstant.FALSE));
                globalDelta1 = delta1;
                continue;
            }
            if (pi2.isEmpty()) {
                globalSigma2 = Disjunction.of(globalSigma2, Conjunction.of(Conjunction.of(sigma2), delta1));
                continue;
            }
            if (sigma2.isEmpty()) {
                Formula formula3 = Disjunction.of((Formula)var6_10, Conjunction.of(Conjunction.of(pi2), delta1));
                continue;
            }
            Formula sigma2Formula = SimplifierRepository.SYNTACTIC_FIXPOINT.apply(Conjunction.of(Conjunction.of(sigma2), delta1));
            Formula pi2Formula = SimplifierRepository.SYNTACTIC_FIXPOINT.apply(Conjunction.of(pi2));
            pairs.add(Sigma2Pi2Pair.of(atomicPropositions, sigma2Formula, pi2Formula));
        }
        if (!globalSigma2.equals(BooleanConstant.FALSE)) {
            pairs.add(Sigma2Pi2Pair.of(atomicPropositions, SimplifierRepository.SYNTACTIC_FIXPOINT.apply(Disjunction.of(globalSigma2, globalDelta1)), BooleanConstant.TRUE));
            globalDelta1 = BooleanConstant.FALSE;
        }
        if (!var6_10.equals(BooleanConstant.FALSE)) {
            pairs.add(Sigma2Pi2Pair.of(atomicPropositions, BooleanConstant.TRUE, SimplifierRepository.SYNTACTIC_FIXPOINT.apply(Disjunction.of((Formula)var6_10, globalDelta1))));
            globalDelta1 = BooleanConstant.FALSE;
        }
        if (!globalDelta1.equals(BooleanConstant.FALSE)) {
            pairs.add(Sigma2Pi2Pair.of(atomicPropositions, globalDelta1, BooleanConstant.TRUE));
        }
        return pairs;
    }

    @AutoValue
    static abstract class Sigma2Pi2Pair {
        Sigma2Pi2Pair() {
        }

        abstract LabelledFormula sigma2();

        abstract LabelledFormula pi2();

        static Sigma2Pi2Pair of(List<String> atomicPropositions, Formula sigma2, Formula pi2) {
            Preconditions.checkArgument((boolean)SyntacticFragments.SIGMA_2.contains(sigma2));
            Preconditions.checkArgument((boolean)SyntacticFragments.PI_2.contains(pi2));
            return new AutoValue_AbstractNormalformDRAConstruction_Sigma2Pi2Pair(LabelledFormula.of(sigma2, atomicPropositions), LabelledFormula.of(pi2, atomicPropositions));
        }
    }
}

