/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.automaton.symbolic.SymbolicBooleanOperations;
import owl.bdd.BddSetFactory;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.logic.propositional.PropositionalFormula;
import owl.ltl.BooleanConstant;
import owl.ltl.LabelledFormula;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.ltl2dra.AbstractNormalformDRAConstruction;

public class SymbolicNormalformDRAConstruction
extends AbstractNormalformDRAConstruction
implements Function<LabelledFormula, SymbolicAutomaton<?>> {
    private BddSetFactory factory;

    public SymbolicNormalformDRAConstruction(BddSetFactory factory) {
        this(true, factory);
    }

    public SymbolicNormalformDRAConstruction(boolean useDualConstruction, BddSetFactory factory) {
        super(useDualConstruction);
        this.factory = factory;
    }

    @Override
    public SymbolicAutomaton<?> apply(LabelledFormula labelledFormula) {
        List<AbstractNormalformDRAConstruction.Sigma2Pi2Pair> pairs = this.group(labelledFormula.nnf());
        if (pairs.isEmpty()) {
            pairs = List.of(AbstractNormalformDRAConstruction.Sigma2Pi2Pair.of(labelledFormula.atomicPropositions(), BooleanConstant.FALSE, BooleanConstant.FALSE));
        }
        Factories explicitFactories = FactorySupplier.defaultSupplier().getFactories(labelledFormula.atomicPropositions(), EquivalenceClassFactory.Encoding.AP_SEPARATE);
        HashMap<LabelledFormula, Integer> coSafetySafetyIndices = new HashMap<LabelledFormula, Integer>();
        HashMap<LabelledFormula, Integer> safetyCoSafetyIndices = new HashMap<LabelledFormula, Integer>();
        ArrayList<SymbolicAutomaton<EmersonLeiAcceptance>> automata = new ArrayList<SymbolicAutomaton<EmersonLeiAcceptance>>();
        ArrayList disjuncts = new ArrayList();
        for (AbstractNormalformDRAConstruction.Sigma2Pi2Pair formulaPair : pairs) {
            Integer safetyCoSafetyIndex;
            LabelledFormula sigma2 = formulaPair.sigma2();
            LabelledFormula pi2 = formulaPair.pi2();
            Integer coSafetySafetyIndex = (Integer)coSafetySafetyIndices.get(sigma2);
            if (coSafetySafetyIndex == null) {
                coSafetySafetyIndex = automata.size();
                coSafetySafetyIndices.put(sigma2, coSafetySafetyIndex);
                automata.add(SymbolicAutomaton.of(DeterministicConstructions.CoSafetySafetyRoundRobin.of(explicitFactories, sigma2.formula(), true, false), this.factory, labelledFormula.atomicPropositions()));
            }
            if ((safetyCoSafetyIndex = (Integer)safetyCoSafetyIndices.get(pi2)) == null) {
                safetyCoSafetyIndex = automata.size();
                safetyCoSafetyIndices.put(pi2, safetyCoSafetyIndex);
                automata.add(SymbolicAutomaton.of(DeterministicConstructions.SafetyCoSafetyRoundRobin.of(explicitFactories, pi2.formula(), true, false), this.factory, labelledFormula.atomicPropositions()));
            }
            disjuncts.add(PropositionalFormula.Conjunction.of(PropositionalFormula.Variable.of(coSafetySafetyIndex), PropositionalFormula.Variable.of(safetyCoSafetyIndex)));
        }
        return SymbolicBooleanOperations.deterministicProduct(PropositionalFormula.Disjunction.of(disjuncts), automata);
    }
}

