/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AnnotatedStateOptimisation;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.translations.BlockingElements;
import owl.translations.ltl2dra.SymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricDRAConstruction<R extends GeneralizedRabinAcceptance>
implements Function<LabelledFormula, Automaton<SymmetricRankingState, R>> {
    private final boolean optimizeInitialState;
    private final Class<R> acceptanceClass;
    private final SymmetricLDBAConstruction<?> ldbaConstruction;

    private SymmetricDRAConstruction(Class<R> acceptanceClass, boolean optimizeInitialState) {
        assert (acceptanceClass.equals(GeneralizedRabinAcceptance.class) || acceptanceClass.equals(RabinAcceptance.class));
        Class buchiAcceptance = acceptanceClass.equals(GeneralizedRabinAcceptance.class) ? GeneralizedBuchiAcceptance.class : BuchiAcceptance.class;
        this.acceptanceClass = acceptanceClass;
        this.optimizeInitialState = optimizeInitialState;
        this.ldbaConstruction = SymmetricLDBAConstruction.of(buchiAcceptance);
    }

    public static <R extends GeneralizedRabinAcceptance> SymmetricDRAConstruction<R> of(Class<R> clazz, boolean optimizeInitialState) {
        return new SymmetricDRAConstruction<R>(clazz, optimizeInitialState);
    }

    @Override
    public Automaton<SymmetricRankingState, R> apply(LabelledFormula formula) {
        AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, ?, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba = this.ldbaConstruction.apply(formula);
        final Builder builder = new Builder(ldba);
        AbstractMemoizingAutomaton.EdgeImplementation automaton = new AbstractMemoizingAutomaton.EdgeImplementation<SymmetricRankingState, R>(ldba.acceptingComponent().atomicPropositions(), ldba.factory(), Collections3.ofNullable(builder.initialState), (GeneralizedRabinAcceptance)builder.acceptance){

            @Override
            public Edge<SymmetricRankingState> edgeImpl(SymmetricRankingState state, BitSet valuation) {
                return builder.edge(state, valuation);
            }
        };
        return this.optimizeInitialState ? AnnotatedStateOptimisation.optimizeInitialState(automaton) : automaton;
    }

    private class Builder {
        private final R acceptance;
        private final Table<Integer, SymmetricEvaluatedFixpoints, GeneralizedRabinAcceptance.RabinPair> pairs;
        private final GeneralizedRabinAcceptance.RabinPair safetyRabinPair;
        @Nullable
        private final SymmetricRankingState initialState;
        private final List<Set<Map<Integer, EquivalenceClass>>> initialComponentSccs;
        private final AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, ?, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba;

        private Builder(AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, ?, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba) {
            this.initialComponentSccs = SccDecomposition.of(ldba.initialComponent()).sccs();
            this.ldba = ldba;
            this.pairs = HashBasedTable.create();
            Map<Integer, EquivalenceClass> ldbaInitialState = ldba.initialComponent().initialStates().isEmpty() ? Map.of() : ldba.initialComponent().initialState();
            TreeSet<SymmetricEvaluatedFixpoints> fixpoints = new TreeSet<SymmetricEvaluatedFixpoints>(ldba.annotation());
            if (SymmetricDRAConstruction.this.acceptanceClass.equals(RabinAcceptance.class)) {
                RabinAcceptance.Builder builder = new RabinAcceptance.Builder();
                fixpoints.forEach(x -> ldbaInitialState.keySet().stream().sorted().forEach(y -> this.pairs.put(y, x, (Object)builder.add())));
                this.safetyRabinPair = builder.add();
                this.acceptance = (GeneralizedRabinAcceptance)SymmetricDRAConstruction.this.acceptanceClass.cast(builder.build());
            } else {
                assert (SymmetricDRAConstruction.this.acceptanceClass.equals(GeneralizedRabinAcceptance.class));
                GeneralizedRabinAcceptance.Builder builder = new GeneralizedRabinAcceptance.Builder();
                int infSets = ((EmersonLeiAcceptance)ldba.acceptance()).acceptanceSets();
                fixpoints.forEach(x -> ldbaInitialState.keySet().stream().sorted().forEach(y -> this.pairs.put(y, x, (Object)builder.add(infSets))));
                this.safetyRabinPair = builder.add(infSets);
                this.acceptance = (GeneralizedRabinAcceptance)SymmetricDRAConstruction.this.acceptanceClass.cast(builder.build());
            }
            this.initialState = ldbaInitialState.isEmpty() ? null : this.edge(ldbaInitialState, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)ImmutableTable.of(), null).successor();
        }

        private Edge<SymmetricRankingState> edge(Map<Integer, EquivalenceClass> successor, Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState> previousTable, @Nullable BitSet valuation) {
            for (EquivalenceClass clazz2 : successor.values()) {
                if (!BlockingElements.isBlockedByTransient(clazz2) && !BlockingElements.isBlockedBySafety(clazz2)) continue;
                if (this.safetyRabinPair.hasInfSet()) {
                    BitSet acceptanceSets = new BitSet();
                    this.safetyRabinPair.infSetStream().forEach(acceptanceSets::set);
                    return Edge.of(SymmetricRankingState.of(successor), acceptanceSets);
                }
                return Edge.of(SymmetricRankingState.of(successor));
            }
            HashBasedTable successorTable = HashBasedTable.create();
            successor.forEach((index, clazz) -> {
                for (SymmetricProductState x : this.ldba.stateAnnotation().apply((Integer)index, (EquivalenceClass)clazz)) {
                    if (!this.ldba.acceptingComponent().states().contains(x)) continue;
                    SymmetricProductState oldCell = (SymmetricProductState)successorTable.put(index, (Object)x.evaluatedFixpoints, (Object)x);
                    assert (oldCell == null);
                }
            });
            BitSet acceptance = new BitSet();
            for (Table.Cell entry : previousTable.cellSet()) {
                Integer index2 = (Integer)entry.getRowKey();
                SymmetricProductState state = (SymmetricProductState)entry.getValue();
                SymmetricEvaluatedFixpoints fixpoints = (SymmetricEvaluatedFixpoints)entry.getColumnKey();
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                assert (fixpoints != null && state != null && index2 != null) : "Malformed data-structure";
                Edge<SymmetricProductState> edge = this.ldba.acceptingComponent().edge(state, valuation);
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)this.pairs.get((Object)index2, (Object)fixpoints);
                if (edge == null || !successorTable.contains((Object)index2, (Object)fixpoints)) {
                    acceptance.set(pair.finSet());
                    continue;
                }
                successorTable.put((Object)index2, (Object)fixpoints, (Object)edge.successor());
                edge.colours().forEach(i -> acceptance.set(pair.infSet(i)));
            }
            return Edge.of(SymmetricRankingState.of(successor, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)successorTable), acceptance);
        }

        @Nullable
        private Edge<SymmetricRankingState> edge(SymmetricRankingState state, BitSet valuation) {
            Map<Integer, EquivalenceClass> successor = this.ldba.initialComponent().successor((Map<Integer, EquivalenceClass>)state.state(), valuation);
            if (successor == null) {
                return null;
            }
            if (this.initialComponentSccs.stream().anyMatch(x -> x.contains(state.state()) && !x.contains(successor))) {
                return this.edge(successor, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)ImmutableTable.of(), valuation).withoutAcceptance();
            }
            return this.edge(successor, state.table(), valuation);
        }
    }
}

