/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.collections.Collections3;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.translations.BlockingElements;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricProductState;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Predicates;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;

public final class AsymmetricLDBAConstruction<B extends GeneralizedBuchiAcceptance>
implements Function<LabelledFormula, AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, B, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>>> {
    private final Class<B> acceptanceClass;

    private AsymmetricLDBAConstruction(Class<B> acceptanceClass) {
        this.acceptanceClass = acceptanceClass;
        assert (BuchiAcceptance.class.equals(acceptanceClass) || GeneralizedBuchiAcceptance.class.equals(acceptanceClass));
    }

    public static <B extends GeneralizedBuchiAcceptance> AsymmetricLDBAConstruction<B> of(Class<B> clazz) {
        return new AsymmetricLDBAConstruction<B>(clazz);
    }

    @Override
    public AnnotatedLDBA<EquivalenceClass, AsymmetricProductState, B, SortedSet<AsymmetricEvaluatedFixpoints>, Function<EquivalenceClass, Set<AsymmetricProductState>>> apply(LabelledFormula input) {
        Set<Object> blockingCoSafetyOperators;
        LabelledFormula formula = input.nnf();
        final Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        EquivalenceClass formulaClass = factories.eqFactory.of(formula.formula());
        int acceptanceSets = 1;
        TreeSet<Fixpoints> knownFixpoints = new TreeSet<Fixpoints>();
        HashMap<Fixpoints, AsymmetricEvaluatedFixpoints> evaluationMap = new HashMap<Fixpoints, AsymmetricEvaluatedFixpoints>();
        HashMap<AsymmetricEvaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata> automataMap = new HashMap<AsymmetricEvaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata>();
        if (SyntacticFragments.isSafety(formulaClass) || SyntacticFragments.isCoSafety(formulaClass)) {
            blockingCoSafetyOperators = Set.of();
        } else {
            for (Fixpoints fixpoints : Selector.selectAsymmetric(formula.formula(), false)) {
                Fixpoints simplified = fixpoints.simplified();
                if (fixpoints.greatestFixpoints().isEmpty()) continue;
                if (evaluationMap.containsKey(simplified)) {
                    knownFixpoints.add(fixpoints);
                    continue;
                }
                AsymmetricEvaluatedFixpoints evaluatedFixpoints = AsymmetricEvaluatedFixpoints.build(simplified, factories);
                if (evaluatedFixpoints == null) continue;
                knownFixpoints.add(fixpoints);
                evaluationMap.put(simplified, evaluatedFixpoints);
                automataMap.put(evaluatedFixpoints, evaluatedFixpoints.deterministicAutomata(factories, this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class)));
            }
            blockingCoSafetyOperators = BlockingElements.blockingCoSafetyFormulas(formulaClass);
            if (this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class)) {
                for (AsymmetricEvaluatedFixpoints.DeterministicAutomata automata : automataMap.values()) {
                    acceptanceSets = Math.max(acceptanceSets, AsymmetricLDBAConstruction.acceptanceSets(automata));
                }
            }
        }
        AcceptingComponentBuilder acceptingComponentBuilder = new AcceptingComponentBuilder(factories, acceptanceSets);
        EquivalenceClass initialState = factories.eqFactory.of(formula.formula()).unfold();
        if (initialState.isTrue()) {
            initialState = factories.eqFactory.of(true);
        } else if (initialState.isFalse()) {
            initialState = factories.eqFactory.of(false);
        }
        HashMap jumps = new HashMap();
        Consumer<EquivalenceClass> jumpGenerator = x -> {
            if (SyntacticFragments.isSafety(x) || !Collections.disjoint(x.temporalOperators(), blockingCoSafetyOperators) || BlockingElements.isBlockedByTransient(x) || BlockingElements.isBlockedByCoSafety(x)) {
                return;
            }
            ArrayList<AsymmetricProductState> productStates = new ArrayList<AsymmetricProductState>();
            Set allModalOperators = x.temporalOperators(true).stream().filter(Predicates.IS_GREATEST_FIXPOINT).collect(Collectors.toSet());
            for (Fixpoints fixpoints : knownFixpoints) {
                AsymmetricProductState productState;
                if (!fixpoints.allFixpointsPresent(allModalOperators)) continue;
                Fixpoints simplifiedFixpoints = fixpoints.simplified();
                AsymmetricEvaluatedFixpoints evaluatedFixpoints = (AsymmetricEvaluatedFixpoints)evaluationMap.get(simplifiedFixpoints);
                EquivalenceClass remainder = x.unfold().substitute(new Rewriter.ToCoSafety(simplifiedFixpoints.greatestFixpoints()));
                if (remainder.isFalse()) continue;
                if (evaluatedFixpoints.language().implies(remainder)) {
                    productState = acceptingComponentBuilder.createState(factories.eqFactory.of(BooleanConstant.TRUE), evaluatedFixpoints, (AsymmetricEvaluatedFixpoints.DeterministicAutomata)automataMap.get(evaluatedFixpoints));
                } else {
                    if (AsymmetricLDBAConstruction.dependsOnExternalAtoms(remainder, evaluatedFixpoints)) continue;
                    productState = acceptingComponentBuilder.createState(remainder.unfold(), evaluatedFixpoints, (AsymmetricEvaluatedFixpoints.DeterministicAutomata)automataMap.get(evaluatedFixpoints));
                }
                if (productState.language().isFalse()) continue;
                productStates.add(productState);
            }
            jumps.put(x, Set.copyOf(Collections3.maximalElements(productStates, (x1, y) -> {
                if (x1.language().equals(y.language())) {
                    return x1.evaluatedFixpoints.compareTo(y.evaluatedFixpoints) < 0;
                }
                return x1.language().implies(y.language());
            })));
        };
        final DeterministicConstructions.Tracking tracking = new DeterministicConstructions.Tracking(factories);
        final BitSet bitSet = new BitSet();
        bitSet.set(0, acceptanceSets);
        Function<EquivalenceClass, Set> jumpLookup = x -> jumps.getOrDefault(x, Set.of());
        AbstractMemoizingAutomaton.EdgeTreeImplementation<EquivalenceClass, AllAcceptance> automaton = new AbstractMemoizingAutomaton.EdgeTreeImplementation<EquivalenceClass, AllAcceptance>(factories.eqFactory.atomicPropositions(), factories.vsFactory, initialState.isFalse() ? Set.of() : Set.of(initialState), AllAcceptance.INSTANCE){

            @Override
            public MtBdd<Edge<EquivalenceClass>> edgeTreeImpl(EquivalenceClass state) {
                return tracking.successorTree(state).map(successors -> {
                    EquivalenceClass successor = (EquivalenceClass)Iterables.getOnlyElement((Iterable)successors);
                    if (successor.isFalse()) {
                        return Set.of();
                    }
                    if (successor.isTrue()) {
                        return Set.of(Edge.of(factories2.eqFactory.of(true), bitSet));
                    }
                    return Set.of(SyntacticFragments.isSafety(successor) ? Edge.of(successor, bitSet) : Edge.of(successor));
                });
            }
        };
        HashMapAutomaton<EquivalenceClass, AllAcceptance> initialComponent = HashMapAutomaton.copyOf(automaton);
        assert (initialComponent.is(Automaton.Property.DETERMINISTIC));
        initialComponent.states().forEach(jumpGenerator);
        return AnnotatedLDBA.build(initialComponent, acceptingComponentBuilder, jumpLookup, EquivalenceClass::language, new TreeSet(evaluationMap.values()), jumpLookup);
    }

    private static EquivalenceClass initialState(EquivalenceClass clazz, EquivalenceClass environment) {
        EquivalenceClass state = clazz.unfold();
        if (state.isTrue()) {
            return clazz.factory().of(true);
        }
        if (state.isFalse()) {
            return clazz.factory().of(false);
        }
        return environment.implies(state) ? clazz.factory().of(true) : state;
    }

    private static EquivalenceClass successor(EquivalenceClass clazz, BitSet valuation, EquivalenceClass environment) {
        EquivalenceClass successor = clazz.temporalStep(valuation).unfold();
        if (successor.isTrue()) {
            return clazz.factory().of(true);
        }
        if (successor.isFalse()) {
            return clazz.factory().of(false);
        }
        return environment.implies(successor) ? clazz.factory().of(true) : successor;
    }

    private static int acceptanceSets(AsymmetricEvaluatedFixpoints.DeterministicAutomata a) {
        return (a.coSafety.isEmpty() && a.fCoSafety.isEmpty() ? 0 : 1) + (a.gfCoSafetyAutomaton == null ? 0 : ((GeneralizedBuchiAcceptance)a.gfCoSafetyAutomaton.acceptance()).acceptanceSets());
    }

    private static boolean dependsOnExternalAtoms(EquivalenceClass remainder, AsymmetricEvaluatedFixpoints obligation) {
        BitSet remainderAP = remainder.atomicPropositions(true);
        BitSet atoms = obligation.language().atomicPropositions(true);
        assert (!remainderAP.isEmpty());
        assert (!atoms.isEmpty());
        return !remainderAP.intersects(atoms);
    }

    final class AcceptingComponentBuilder
    implements AnnotatedLDBA.AcceptingComponentBuilder<AsymmetricProductState, B> {
        final int acceptanceSets;
        final Factories factories;
        final List<AsymmetricProductState> anchors = new ArrayList<AsymmetricProductState>();

        AcceptingComponentBuilder(Factories factories, int acceptanceSets) {
            this.factories = factories;
            this.acceptanceSets = acceptanceSets;
        }

        AsymmetricProductState createState(EquivalenceClass remainder, AsymmetricEvaluatedFixpoints evaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
            assert (SyntacticFragments.isCoSafety(remainder));
            EquivalenceClass safety = (EquivalenceClass)automata.safetyAutomaton.initialState();
            EquivalenceClass current = remainder;
            if (SyntacticFragments.isSafety(remainder)) {
                safety = current.and(safety);
                current = this.factories.eqFactory.of(true);
            } else {
                current = AsymmetricLDBAConstruction.initialState(current, safety.and(evaluatedFixpoints.language()).unfold());
            }
            if (automata.coSafety.isEmpty() && automata.fCoSafety.isEmpty()) {
                return new AsymmetricProductState(0, safety, current, List.of(), evaluatedFixpoints, automata);
            }
            EquivalenceClass[] nextCoSafety = new EquivalenceClass[automata.coSafety.size()];
            for (int i = 0; i < nextCoSafety.length; ++i) {
                nextCoSafety[i] = AsymmetricLDBAConstruction.initialState(automata.coSafety.get(i), current);
            }
            if (current.isTrue()) {
                if (automata.coSafety.isEmpty()) {
                    current = AsymmetricLDBAConstruction.initialState(automata.fCoSafety.get(0), safety);
                } else {
                    current = AsymmetricLDBAConstruction.initialState(nextCoSafety[0], safety);
                    nextCoSafety[0] = this.factories.eqFactory.of(true);
                }
            }
            int index = automata.coSafety.isEmpty() ? -automata.fCoSafety.size() : 0;
            return new AsymmetricProductState(index, safety, current, List.of(nextCoSafety), evaluatedFixpoints, automata);
        }

        @Override
        public void addInitialStates(Collection<? extends AsymmetricProductState> initialStates) {
            this.anchors.addAll(List.copyOf(initialStates));
        }

        @Override
        public MutableAutomaton<AsymmetricProductState, B> build() {
            return HashMapAutomaton.copyOf(new AbstractMemoizingAutomaton.EdgeImplementation<AsymmetricProductState, B>(this.factories.eqFactory.atomicPropositions(), this.factories.vsFactory, Set.copyOf(this.anchors), (GeneralizedBuchiAcceptance)AsymmetricLDBAConstruction.this.acceptanceClass.cast(GeneralizedBuchiAcceptance.of(this.acceptanceSets))){

                @Override
                protected BitSet stateAtomicPropositions(AsymmetricProductState state) {
                    BitSet sensitiveAlphabet = new BitSet();
                    sensitiveAlphabet.or(state.currentCoSafety.atomicPropositions(false));
                    sensitiveAlphabet.or(state.safety.atomicPropositions(false));
                    for (EquivalenceClass clazz : state.nextCoSafety) {
                        sensitiveAlphabet.or(clazz.atomicPropositions(false));
                    }
                    for (EquivalenceClass clazz : state.automata.fCoSafety) {
                        sensitiveAlphabet.or(clazz.atomicPropositions(false));
                    }
                    sensitiveAlphabet.or(state.evaluatedFixpoints.language().atomicPropositions(true));
                    return sensitiveAlphabet;
                }

                @Override
                protected Edge<AsymmetricProductState> edgeImpl(AsymmetricProductState state, BitSet valuation) {
                    return AcceptingComponentBuilder.this.edge(state, valuation);
                }
            });
        }

        @Nullable
        private Edge<AsymmetricProductState> edge(AsymmetricProductState state, BitSet valuation) {
            int usedAcceptanceSets;
            int j;
            AsymmetricEvaluatedFixpoints.DeterministicAutomata automata = state.automata;
            EquivalenceClass safetySuccessor = automata.safetyAutomaton.successor(state.safety, valuation);
            if (safetySuccessor == null) {
                return null;
            }
            EquivalenceClass currentCoSafetySuccessor = AsymmetricLDBAConstruction.successor(state.currentCoSafety, valuation, safetySuccessor);
            EquivalenceClass assumptions = currentCoSafetySuccessor.and(safetySuccessor);
            List<EquivalenceClass> nextSuccessors = state.nextCoSafety.stream().map(x -> AsymmetricLDBAConstruction.successor(x, valuation, assumptions)).collect(Collectors.toList());
            boolean acceptingEdge = false;
            boolean currentSuccessful = false;
            if (currentCoSafetySuccessor.isTrue()) {
                currentSuccessful = true;
                j = this.scan(state.index + 1, nextSuccessors, valuation, assumptions, automata);
                if (j >= automata.coSafety.size()) {
                    acceptingEdge = true;
                    j = this.scan(-automata.fCoSafety.size(), nextSuccessors, valuation, assumptions, automata);
                    if (j >= automata.coSafety.size()) {
                        j = -automata.fCoSafety.size();
                    }
                }
                if (j < 0) {
                    currentCoSafetySuccessor = AsymmetricLDBAConstruction.initialState(automata.fCoSafety.get(automata.fCoSafety.size() + j), assumptions);
                } else if (!nextSuccessors.isEmpty()) {
                    currentCoSafetySuccessor = nextSuccessors.get(j).and(AsymmetricLDBAConstruction.initialState(automata.coSafety.get(j), assumptions));
                }
            } else {
                j = state.index;
            }
            for (int i = 0; i < nextSuccessors.size(); ++i) {
                if (currentSuccessful && i == j) {
                    nextSuccessors.set(i, this.factories.eqFactory.of(BooleanConstant.TRUE));
                    continue;
                }
                nextSuccessors.set(i, nextSuccessors.get(i).and(AsymmetricLDBAConstruction.initialState(automata.coSafety.get(i), assumptions)));
            }
            AsymmetricProductState successor = new AsymmetricProductState(j, safetySuccessor, currentCoSafetySuccessor, nextSuccessors, state.evaluatedFixpoints, automata);
            if (successor.language().isFalse()) {
                return null;
            }
            BitSet acceptance = new BitSet();
            if (acceptingEdge) {
                acceptance.set(0);
            }
            if (automata.gfCoSafetyAutomaton != null) {
                assert (AsymmetricLDBAConstruction.this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class));
                DeterministicConstructions.GfCoSafety automaton = automata.gfCoSafetyAutomaton;
                Edge<RoundRobinState> edge = automaton.edge((RoundRobinState)automaton.initialState(), valuation);
                assert (edge.successor().equals(automaton.initialState()));
                edge.colours().forEach(x -> acceptance.set(x + 1));
            }
            if ((usedAcceptanceSets = AsymmetricLDBAConstruction.acceptanceSets(automata)) != 0 || successor.currentCoSafety.isTrue()) {
                acceptance.set(usedAcceptanceSets, this.acceptanceSets);
            }
            return Edge.of(successor, acceptance);
        }

        private int scan(int index, List<EquivalenceClass> nextCoSafety, BitSet valuation, EquivalenceClass environment, AsymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
            int i;
            for (i = index; i < 0; ++i) {
                EquivalenceClass successor = AsymmetricLDBAConstruction.successor(automata.fCoSafety.get(automata.fCoSafety.size() + i), valuation, environment);
                if (successor.isTrue()) continue;
                return i;
            }
            while (i < nextCoSafety.size() && nextCoSafety.get(i).isTrue()) {
                ++i;
            }
            return i;
        }
    }
}

