/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2nba;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.ltl.Formula;
import owl.translations.canonical.RoundRobinState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class ProductState {
    public final Formula safety;
    @Nullable
    public final RoundRobinState<Formula> liveness;
    public final SymmetricEvaluatedFixpoints evaluatedFixpoints;
    public final SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata;
    private final int hashCode;

    ProductState(Formula safety, @Nullable RoundRobinState<Formula> liveness, SymmetricEvaluatedFixpoints evaluatedFixpoints, SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata) {
        this.liveness = liveness;
        this.evaluatedFixpoints = Objects.requireNonNull(evaluatedFixpoints);
        this.safety = Objects.requireNonNull(safety);
        this.automata = Objects.requireNonNull(automata);
        this.hashCode = Objects.hash(liveness, evaluatedFixpoints, safety);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductState)) {
            return false;
        }
        ProductState that = (ProductState)o;
        return that.hashCode == this.hashCode && Objects.equals(this.safety, that.safety) && Objects.equals(this.liveness, that.liveness) && Objects.equals(this.evaluatedFixpoints, that.evaluatedFixpoints);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String[] pieces = new String[]{"GWR=" + this.safety, this.liveness == null ? null : "FUM=" + this.liveness};
        return this.evaluatedFixpoints + Arrays.stream(pieces).filter(Objects::nonNull).collect(Collectors.joining(", ", " [", "]"));
    }
}

