/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2nba;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.Either;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2nba.ProductState;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricNBAConstruction<B extends GeneralizedBuchiAcceptance>
implements Function<LabelledFormula, Automaton<Either<Formula, ProductState>, B>> {
    private final Class<B> acceptanceClass;

    private SymmetricNBAConstruction(Class<B> acceptanceClass) {
        this.acceptanceClass = acceptanceClass;
        assert (BuchiAcceptance.class.equals(acceptanceClass) || GeneralizedBuchiAcceptance.class.equals(acceptanceClass));
    }

    public static <B extends GeneralizedBuchiAcceptance> Function<LabelledFormula, Automaton<Either<Formula, ProductState>, B>> of(Class<B> clazz) {
        return new SymmetricNBAConstruction<B>(clazz);
    }

    @Override
    public Automaton<Either<Formula, ProductState>, B> apply(LabelledFormula input) {
        LabelledFormula formula = input.nnf();
        SymmetricNBA automaton = this.create(formula);
        HashMapAutomaton mutableAutomaton = HashMapAutomaton.copyOf(automaton);
        AcceptanceOptimizations.removeDeadStates(mutableAutomaton);
        return mutableAutomaton;
    }

    private SymmetricNBA create(LabelledFormula formula) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        HashMap<Fixpoints, Set<SymmetricEvaluatedFixpoints>> evaluationMap = new HashMap<Fixpoints, Set<SymmetricEvaluatedFixpoints>>();
        HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.NonDeterministicAutomata> automataMap = new HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.NonDeterministicAutomata>();
        NonDeterministicConstructions.Tracking trackingAutomaton = new NonDeterministicConstructions.Tracking(factories, formula.formula());
        HashSet<Fixpoints> knownFixpoints = new HashSet<Fixpoints>();
        int acceptanceSets = 1;
        for (Formula initialFormula : trackingAutomaton.initialStates()) {
            knownFixpoints.addAll(Selector.selectSymmetric(initialFormula, false));
        }
        for (Fixpoints fixpoints : knownFixpoints) {
            Fixpoints simplified = fixpoints.simplified();
            if (evaluationMap.containsKey(simplified)) continue;
            Set<SymmetricEvaluatedFixpoints> evaluatedSet = SymmetricEvaluatedFixpoints.build(formula.formula(), simplified, factories);
            evaluationMap.put(simplified, evaluatedSet);
            for (SymmetricEvaluatedFixpoints evaluated : evaluatedSet) {
                if (automataMap.containsKey(evaluated)) continue;
                SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata = evaluated.nonDeterministicAutomata(factories, this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class));
                automataMap.put(evaluated, automata);
                if (automata.gfCoSafetyAutomaton == null) continue;
                acceptanceSets = Math.max(acceptanceSets, ((GeneralizedBuchiAcceptance)automata.gfCoSafetyAutomaton.acceptance()).acceptanceSets());
            }
        }
        HashSet<Formula> initialStatesA = new HashSet<Formula>();
        HashSet initialStatesB = new HashSet();
        Function<Formula, Set> moveAtoB = state -> {
            if (SyntacticFragments.isCoSafety(state) || SyntacticFragments.isSafety(state) || SyntacticFragments.isFSafety(state) && !state.isSuspendable()) {
                return Set.of();
            }
            Set<Formula.TemporalOperator> allModalOperators = state.subformulas(Formula.TemporalOperator.class);
            Set availableFixpoints = knownFixpoints.stream().filter(x -> x.allFixpointsPresent(allModalOperators)).map(Fixpoints::simplified).collect(Collectors.toSet());
            if (state instanceof Conjunction) {
                for (Formula x2 : state.operands) {
                    if (!(x2 instanceof Formula.TemporalOperator) || !SyntacticFragments.isCoSafety(x2) || !allModalOperators.stream().filter(Predicate.not(SyntacticFragments::isCoSafety)).noneMatch(y -> y.subformulas(Formula.TemporalOperator.class).contains(x2))) continue;
                    return Set.of();
                }
            }
            HashSet bStates = new HashSet();
            Maps.filterKeys((Map)evaluationMap, availableFixpoints::contains).forEach((fixpoints, set) -> {
                for (SymmetricEvaluatedFixpoints symmetricEvaluatedFixpoints : set) {
                    Formula remainder = state.unfold().substitute(new Rewriter.ToSafety((Fixpoints)fixpoints));
                    if (BooleanConstant.FALSE.equals(state)) {
                        return;
                    }
                    SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata = (SymmetricEvaluatedFixpoints.NonDeterministicAutomata)automataMap.get(symmetricEvaluatedFixpoints);
                    Set<Formula> safety = automata.safetyAutomaton.initialStatesWithRemainder(remainder);
                    for (Formula safetyState : safety) {
                        if (automata.gfCoSafetyAutomaton == null) {
                            bStates.add(new ProductState(safetyState, null, symmetricEvaluatedFixpoints, automata));
                            continue;
                        }
                        for (RoundRobinState gfCoSafetyState : automata.gfCoSafetyAutomaton.initialStates()) {
                            bStates.add(new ProductState(safetyState, gfCoSafetyState, symmetricEvaluatedFixpoints, automata));
                        }
                    }
                }
            });
            return bStates;
        };
        for (Formula initialFormula : trackingAutomaton.initialStates()) {
            if (SyntacticFragments.isGfCoSafety(initialFormula)) {
                initialStatesB.addAll(moveAtoB.apply(initialFormula));
                continue;
            }
            initialStatesA.add(initialFormula);
        }
        return new SymmetricNBA(this, initialStatesA, initialStatesB, (GeneralizedBuchiAcceptance)this.acceptanceClass.cast(GeneralizedBuchiAcceptance.of(acceptanceSets)), trackingAutomaton, acceptanceSets, factories, "LTL to NBA (symmetric) for formula: " + formula, moveAtoB);
    }

    private static final class SymmetricNBA
    extends AbstractMemoizingAutomaton.PartitionedEdgeTreeImplementation<Formula, ProductState, B> {
        private final Function<Formula, Set<ProductState>> moveAtoB;
        private final NonDeterministicConstructions.Tracking trackingAutomaton;
        private final int acceptanceSets;
        private final Factories factories;
        private final String name;
        final /* synthetic */ SymmetricNBAConstruction this$0;

        public SymmetricNBA(Set<Formula> initialStatesA, Set<ProductState> initialStatesB, B acceptance, NonDeterministicConstructions.Tracking trackingAutomaton, int acceptanceSets, Factories factories, String name, Function<Formula, Set<ProductState>> moveAtoB) {
            this.this$0 = var1_1;
            super(factories.eqFactory.atomicPropositions(), factories.vsFactory, initialStatesA, initialStatesB, acceptance);
            this.moveAtoB = moveAtoB;
            this.trackingAutomaton = trackingAutomaton;
            this.acceptanceSets = acceptanceSets;
            this.factories = factories;
            this.name = name;
        }

        @Override
        protected MtBdd<Edge<Formula>> edgeTreeImplA(Formula state) {
            return this.trackingAutomaton.edgeTree(state).map(x -> this.buildEdgeA(Edges.successors(x)));
        }

        private Set<Edge<Formula>> buildEdgeA(Set<Formula> successors) {
            HashSet<Edge<Formula>> edges = new HashSet<Edge<Formula>>();
            BitSet acceptance = new BitSet();
            acceptance.set(0, this.acceptanceSets);
            for (Formula successor : successors) {
                assert (!BooleanConstant.FALSE.equals(successor));
                if (SyntacticFragments.isSafety(successor)) {
                    edges.add(Edge.of(successor, acceptance));
                    continue;
                }
                edges.add(Edge.of(successor));
            }
            return edges;
        }

        @Override
        protected MtBdd<Edge<ProductState>> edgeTreeImplB(ProductState state) {
            SymmetricEvaluatedFixpoints.NonDeterministicAutomata automata = Objects.requireNonNull(state.automata);
            Formula safetyState = Objects.requireNonNull(state.safety);
            NonDeterministicConstructions.Safety safetyAutomaton = automata.safetyAutomaton;
            if (automata.gfCoSafetyAutomaton == null) {
                return safetyAutomaton.edgeTree(safetyState).map(x -> x.stream().map(y -> {
                    ProductState successor = new ProductState((Formula)y.successor(), null, state.evaluatedFixpoints, automata);
                    BitSet acceptance = new BitSet();
                    acceptance.set(0, this.acceptanceSets);
                    return Edge.of(successor, acceptance);
                }).collect(Collectors.toUnmodifiableSet()));
            }
            RoundRobinState<Formula> livenessState = Objects.requireNonNull(state.liveness);
            NonDeterministicConstructions.GfCoSafety livenessAutomaton = automata.gfCoSafetyAutomaton;
            return MtBddOperations.cartesianProduct(safetyAutomaton.edgeTree(safetyState), livenessAutomaton.edgeTree(livenessState), (safetyEdge, livenessEdge) -> {
                assert (livenessEdge.colours().last().orElse(-1) < this.acceptanceSets);
                ProductState successor = new ProductState((Formula)safetyEdge.successor(), (RoundRobinState)livenessEdge.successor(), state.evaluatedFixpoints, automata);
                BitSet acceptance = livenessEdge.colours().copyInto(new BitSet());
                acceptance.set(((GeneralizedBuchiAcceptance)livenessAutomaton.acceptance()).acceptanceSets(), this.acceptanceSets);
                return Edge.of(successor, acceptance);
            });
        }

        @Override
        protected Set<ProductState> moveAtoB(Formula state) {
            return this.moveAtoB.apply(state);
        }

        @Override
        protected Set<Edge<Either<Formula, ProductState>>> deduplicate(Set<Edge<Either<Formula, ProductState>>> edges) {
            Formula initialComponentSafetyLanguage = BooleanConstant.FALSE;
            HashSet<Edge<Either<Formula, ProductState>>> initialComponentEdges = new HashSet<Edge<Either<Formula, ProductState>>>();
            HashSet<Edge> acceptingComponentEdges = new HashSet<Edge>();
            for (Edge<Either<Formula, ProductState>> edge : edges) {
                if (edge.successor().type() == Either.Type.LEFT) {
                    initialComponentEdges.add(edge);
                    Formula formula = edge.successor().left();
                    if (!SyntacticFragments.isSafety(formula)) continue;
                    initialComponentSafetyLanguage = Disjunction.of(initialComponentSafetyLanguage, formula);
                    continue;
                }
                acceptingComponentEdges.add(edge);
            }
            if (initialComponentSafetyLanguage.equals(BooleanConstant.FALSE)) {
                return edges;
            }
            EquivalenceClass initialComponentLanguage = this.factories.eqFactory.of(initialComponentSafetyLanguage);
            acceptingComponentEdges.removeIf(x -> {
                ProductState productState = (ProductState)((Either)x.successor()).right();
                if (productState.liveness != null) {
                    return false;
                }
                EquivalenceClass stateLanguage = this.factories.eqFactory.of(productState.safety);
                return stateLanguage.implies(initialComponentLanguage);
            });
            if (acceptingComponentEdges.size() + initialComponentEdges.size() == edges.size()) {
                return edges;
            }
            return Sets.union(initialComponentEdges, acceptingComponentEdges);
        }
    }
}

