/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.algorithm.simulations.BuchiSimulation;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.collections.BitSet2;
import owl.collections.Pair;
import owl.command.AutomatonConversionCommands;
import owl.translations.nbadet.NbaAdjMat;
import owl.translations.nbadet.NbaDetConf;
import owl.translations.nbadet.NbaDetState;
import owl.translations.nbadet.NbaLangInclusions;
import owl.translations.nbadet.SmartSucc;

public final class NbaDet {
    private static final Logger logger = Logger.getLogger(NbaDet.class.getName());

    private NbaDet() {
    }

    public static Map<Handler, Level> overrideLogLevel(Level verbosity) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Map<Handler, Level> oldLogLevels = Arrays.stream(rootLogger.getHandlers()).collect(Collectors.toMap(Function.identity(), Handler::getLevel));
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(verbosity);
        }
        logger.setLevel(verbosity);
        return oldLogLevels;
    }

    public static void restoreLogLevel(Map<Handler, Level> oldLogLevels) {
        oldLogLevels.forEach(Handler::setLevel);
    }

    public static <S> Pair<Automaton<Set<S>, BuchiAcceptance>, Set<Pair<Set<S>, Set<S>>>> preprocess(Automaton<S, BuchiAcceptance> aut, AutomatonConversionCommands.Nba2DpaCommand args) {
        Set<Pair<S, S>> incl = NbaLangInclusions.computeLangInclusions(aut, args.computeSims());
        logger.log(Level.FINE, "calculated language inclusions: " + incl.toString());
        if (incl.isEmpty() || !NbaLangInclusions.getQuotientable().containsAll(args.computeSims())) {
            logger.log(Level.FINE, "no (quotientable) inclusions, pass through automaton.");
            Automaton<Set, BuchiAcceptance> quotAut = Views.quotientAutomaton(aut, Set::of);
            Set remainingIncl = incl.stream().map(p -> Pair.of(Set.of(p.fst()), Set.of(p.snd()))).collect(Collectors.toSet());
            return Pair.of(quotAut, remainingIncl);
        }
        Set<Pair<S, S>> equivRel = BuchiSimulation.computeEquivalence(incl);
        HashMap classMap = new HashMap();
        for (Object state : aut.states()) {
            classMap.put(state, new HashSet());
            equivRel.stream().filter(p -> state.equals(p.fst())).forEach(q -> ((Set)classMap.get(state)).add(q.snd()));
        }
        Automaton<Set, BuchiAcceptance> quotAut = Views.quotientAutomaton(aut, classMap::get);
        if (quotAut.states().size() < aut.states().size()) {
            logger.log(Level.FINE, "Quotienting reduced automaton from " + aut.states().size() + " states to " + quotAut.states().size() + " states.");
        }
        Set remainingIncl = incl.stream().map(p -> Pair.of((Set)classMap.get(p.fst()), (Set)classMap.get(p.snd()))).collect(Collectors.toSet());
        logger.log(Level.FINE, "remaining language inclusions: " + remainingIncl.toString());
        return Pair.of(quotAut, remainingIncl);
    }

    public static <S> Automaton<?, ParityAcceptance> determinize(Automaton<S, ? extends BuchiAcceptance> aut, AutomatonConversionCommands.Nba2DpaCommand args) {
        if (aut.atomicPropositions().size() > 30) {
            throw new UnsupportedOperationException("ERROR: Too many atomic propositions! Only up to 30 are supported.");
        }
        Map<Handler, Level> oldLogLevels = NbaDet.overrideLogLevel(Level.parse(args.verbosity()));
        logger.log(Level.CONFIG, "selected nbadet configuration:\n" + args);
        Pair<Automaton<Set<S>, BuchiAcceptance>, Set<Pair<Set<S>, Set<S>>>> prepAut = NbaDet.preprocess(aut, args);
        NbaDetConf<Set<S>> conf = NbaDetConf.prepare(prepAut.fst(), prepAut.snd(), args);
        Automaton<Object, ParityAcceptance> resultDpa = args.usePowersets() ? NbaDet.determinizeNbaTopo(conf) : NbaDet.determinizeNba(conf);
        NbaDet.restoreLogLevel(oldLogLevels);
        return resultDpa;
    }

    public static <S> Automaton<NbaDetState<S>, ParityAcceptance> determinizeNba(final NbaDetConf<S> conf) {
        logger.log(Level.FINE, "Start naive exploration of DPA.");
        final SmartSucc<S> succHelper = new SmartSucc<S>(conf);
        return new AbstractMemoizingAutomaton.EdgeImplementation<NbaDetState<S>, ParityAcceptance>(conf.aut().original().atomicPropositions(), conf.aut().original().factory(), Set.of(NbaDetState.of(conf, conf.aut().original().initialStates())), NbaDetState.getAcceptance(conf)){
            private boolean logOverridden;

            @Override
            public Edge<NbaDetState<S>> edgeImpl(NbaDetState<S> state, BitSet val) {
                if (!this.logOverridden) {
                    NbaDet.overrideLogLevel(Level.parse(conf.args().verbosity()));
                    this.logOverridden = true;
                }
                return succHelper.successor(state, val);
            }
        };
    }

    public static <S> Automaton<Pair<Integer, NbaDetState<S>>, ParityAcceptance> determinizeNbaTopo(NbaDetConf<S> conf) {
        logger.log(Level.FINE, "Computation of powerset structure of NBA");
        final Automaton<BitSet, AllAcceptance> psAut = NbaDet.createPowerSetAutomaton(conf.aut());
        BitSet psInitial = psAut.initialState();
        SccDecomposition<BitSet> psScci = SccDecomposition.of(psAut);
        final HashMap<BitSet, Integer> sccOf = new HashMap<BitSet, Integer>();
        int i = 0;
        for (Set<BitSet> psScc : psScci.sccs()) {
            for (BitSet bitSet : psScc) {
                sccOf.put(bitSet, i);
            }
            ++i;
        }
        final HashMap<Integer, Automaton<NbaDetState<S>, ParityAcceptance>> sccDpa = new HashMap<Integer, Automaton<NbaDetState<S>, ParityAcceptance>>();
        final HashMap<BitSet, NbaDetState<S>> repMap = new HashMap<BitSet, NbaDetState<S>>();
        i = 0;
        for (Set set : psScci.sccs()) {
            BitSet sccInit = set.contains(psInitial) ? psInitial : (BitSet)set.iterator().next();
            Automaton<BitSet, AllAcceptance> psSccAut = Views.filtered(psAut, Views.Filter.of(Set.of(sccInit), set::contains));
            logger.log(Level.FINE, "Partial exploration of DPA for SCC " + i);
            Pair<Automaton<NbaDetState<S>, ParityAcceptance>, Map<BitSet, NbaDetState<S>>> ret = NbaDet.determinizeNbaAlongScc(psSccAut, conf);
            logger.log(Level.FINE, "resulting partial DPA " + i + " of size " + ret.fst().states().size());
            sccDpa.put(i, ret.fst());
            repMap.putAll(ret.snd());
            ++i;
        }
        logger.log(Level.FINE, "Combination of partial DPAs");
        Pair<Integer, NbaDetState> dpaInitial = Pair.of((Integer)sccOf.get(psInitial), (NbaDetState)repMap.get(psInitial));
        final HashMap<Pair<Integer, NbaDetState>, BitSet> hashMap = new HashMap<Pair<Integer, NbaDetState>, BitSet>();
        hashMap.put(dpaInitial, psInitial);
        return new AbstractMemoizingAutomaton.EdgeImplementation<Pair<Integer, NbaDetState<S>>, ParityAcceptance>(conf.aut().original().atomicPropositions(), conf.aut().original().factory(), Set.of(dpaInitial), NbaDetState.getAcceptance(conf)){

            @Override
            public Edge<Pair<Integer, NbaDetState<S>>> edgeImpl(Pair<Integer, NbaDetState<S>> state, BitSet val) {
                BitSet pSet = (BitSet)hashMap.get(state);
                int psScc = (Integer)sccOf.get(pSet);
                Set<BitSet> refSuc = psAut.successors(pSet, val);
                assert (refSuc.size() == 1);
                BitSet sucPSet = refSuc.iterator().next();
                int sucScc = (Integer)sccOf.get(sucPSet);
                Edge<NbaDetState> retSt = psScc == sucScc ? Objects.requireNonNull(((Automaton)sccDpa.get(psScc)).edge(state.snd(), val)) : Edge.of(Objects.requireNonNull((NbaDetState)repMap.get(sucPSet)));
                Edge ret = retSt.mapSuccessor(x -> Pair.of(sucScc, x));
                if (!hashMap.containsKey(ret.successor())) {
                    hashMap.put(ret.successor(), sucPSet);
                }
                return ret;
            }
        };
    }

    public static <S> Pair<Automaton<NbaDetState<S>, ParityAcceptance>, Map<BitSet, NbaDetState<S>>> determinizeNbaAlongScc(final Automaton<BitSet, ?> refScc, NbaDetConf<S> conf) {
        BitSet psInit = refScc.initialState();
        NbaDetState<S> initDpa = NbaDetState.of(conf, psInit);
        final HashMap<NbaDetState<S>, BitSet> toPS = new HashMap<NbaDetState<S>, BitSet>();
        toPS.put(initDpa, psInit);
        final SmartSucc<S> succHelper = new SmartSucc<S>(conf);
        MutableAutomaton sccAut = MutableAutomatonUtil.asMutable(new AbstractMemoizingAutomaton.EdgeImplementation<NbaDetState<S>, ParityAcceptance>(conf.aut().original().atomicPropositions(), conf.aut().original().factory(), Set.of(initDpa), NbaDetState.getAcceptance(conf)){

            @Override
            public Edge<NbaDetState<S>> edgeImpl(NbaDetState<S> state, BitSet val) {
                BitSet pSet = (BitSet)toPS.get(state);
                Set<BitSet> refSuc = refScc.successors(pSet, val);
                if (refSuc.isEmpty()) {
                    return null;
                }
                assert (refSuc.size() == 1);
                BitSet sucPSet = refSuc.iterator().next();
                Edge suc = succHelper.successor(state, val);
                if (!toPS.containsKey(suc.successor())) {
                    toPS.put(suc.successor(), sucPSet);
                }
                return suc;
            }
        });
        SccDecomposition compScci = SccDecomposition.of(sccAut);
        int minBScc = compScci.bottomSccs().stream().map(sccId -> Pair.of(sccId, compScci.sccs().get((int)sccId).size())).reduce((a, b) -> (Integer)a.snd() <= (Integer)b.snd() ? a : b).orElse(Pair.of(-1, -1)).fst();
        assert (minBScc != -1);
        Set repScc = compScci.sccs().get(minBScc);
        Views.Filter<NbaDetState> onlyTheBotScc = Views.Filter.of(repScc, repScc::contains);
        Automaton trimmedPartialDpa = Views.filtered(sccAut, onlyTheBotScc);
        NbaDetState anyState = trimmedPartialDpa.initialStates().iterator().next();
        HashMap<BitSet, NbaDetState> repMap = new HashMap<BitSet, NbaDetState>();
        repMap.put((BitSet)toPS.get(anyState), anyState);
        ArrayDeque<BitSet> toVisit = new ArrayDeque<BitSet>();
        toVisit.push((BitSet)toPS.get(anyState));
        while (!toVisit.isEmpty()) {
            BitSet curr = (BitSet)toVisit.pop();
            for (Map.Entry<Edge<BitSet>, BddSet> e : refScc.edgeMap(curr).entrySet()) {
                BitSet suc = e.getKey().successor();
                BitSet sym = e.getValue().iterator(refScc.atomicPropositions().size()).next();
                if (repMap.containsKey(suc)) continue;
                repMap.put(suc, trimmedPartialDpa.successor((NbaDetState)repMap.get(curr), sym));
                toVisit.push(suc);
            }
        }
        return Pair.of(trimmedPartialDpa, repMap);
    }

    public static <S> Automaton<BitSet, AllAcceptance> createPowerSetAutomaton(final NbaAdjMat<S> adjMat) {
        return new AbstractMemoizingAutomaton.EdgeImplementation<BitSet, AllAcceptance>(adjMat.original().atomicPropositions(), adjMat.original().factory(), Set.of(BitSet2.copyOf(adjMat.original().initialStates(), arg_0 -> adjMat.stateMap().get(arg_0))), AllAcceptance.INSTANCE){

            @Override
            public Edge<BitSet> edgeImpl(BitSet state, BitSet val) {
                return Edge.of(adjMat.powerSucc(state, val).fst());
            }
        };
    }
}

