/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.Pair;
import owl.translations.nbadet.AutoValue_NbaDetState;
import owl.translations.nbadet.NbaDet;
import owl.translations.nbadet.NbaDetConf;
import owl.translations.nbadet.NbaDetState;
import owl.translations.nbadet.RankedSlice;

final class NbaDetStateFactory<S> {
    private static final Logger logger = Logger.getLogger(NbaDet.class.getName());
    ImmutableBiMap<Integer, S> states;
    public BitSet powerSet;
    public BitSet rSccs;
    public BitSet aSccsBuffer;
    public Optional<Pair<BitSet, Integer>> aSccs;
    public ArrayList<RankedSlice> dSccs;
    public ArrayList<RankedSlice> mSccs;
    public ArrayList<ArrayList<Boolean>> dSccSeenGoodEdge;

    NbaDetStateFactory() {
    }

    private static <S> NbaDetStateFactory<S> of(NbaDetState<S> st) {
        NbaDetStateFactory<S> ret = new NbaDetStateFactory<S>();
        ret.states = st.states;
        ret.powerSet = (BitSet)st.powerSet().clone();
        ret.rSccs = (BitSet)st.rSccs().clone();
        ret.aSccsBuffer = (BitSet)st.aSccsBuffer().clone();
        if (st.aSccs().isEmpty()) {
            ret.aSccs = Optional.empty();
        } else {
            Pair<BitSet, Integer> orig = st.aSccs().get();
            ret.aSccs = Optional.of(Pair.of((BitSet)orig.fst().clone(), orig.snd()));
        }
        ret.dSccs = new ArrayList();
        st.dSccs().forEach(sl -> ret.dSccs.add(RankedSlice.copy(sl.slice())));
        ret.mSccs = new ArrayList();
        st.mSccs().forEach(sl -> ret.mSccs.add(RankedSlice.copy(sl.slice())));
        return ret;
    }

    private NbaDetState<S> freeze() {
        AutoValue_NbaDetState ret = new AutoValue_NbaDetState(this.powerSet, this.rSccs, this.aSccsBuffer, this.aSccs, this.dSccs, this.mSccs);
        ret.states = this.states;
        return ret;
    }

    public static void mapSlicesInplace(ArrayList<RankedSlice> sls, Function<RankedSlice, RankedSlice> fun) {
        for (int i = 0; i < sls.size(); ++i) {
            sls.set(i, fun.apply(sls.get(i)));
        }
    }

    RankedSlice succAndSplit(RankedSlice sl, Function<BitSet, Pair<BitSet, BitSet>> succFun, RankGen rg) {
        ArrayList<Pair<BitSet, Integer>> newSlice = new ArrayList<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> entry : sl.slice()) {
            Pair<BitSet, BitSet> succs = succFun.apply(entry.fst());
            newSlice.add(Pair.of(succs.snd(), rg.fresh()));
            newSlice.add(Pair.of(BitSet2.without(succs.fst(), succs.snd()), entry.snd()));
        }
        return RankedSlice.of(newSlice);
    }

    void applySucc(NbaDetConf<S> conf, BitSet sym, RankGen rankgen) {
        Function<BitSet, Pair> pSucc = set -> conf.aut().powerSucc((BitSet)set, sym);
        Function<BitSet, BitSet> pSuccAll = set -> (BitSet)((Pair)pSucc.apply((BitSet)set)).fst();
        this.powerSet = pSuccAll.apply(this.powerSet);
        this.rSccs = pSuccAll.apply(this.rSccs);
        this.aSccsBuffer = pSuccAll.apply(this.aSccsBuffer);
        this.aSccs = this.aSccs.map(p -> p.mapFst(pSuccAll));
        this.dSccSeenGoodEdge = new ArrayList();
        for (int i = 0; i < this.dSccs.size(); ++i) {
            List<Pair<BitSet, Integer>> dscc = this.dSccs.get(i).slice();
            this.dSccSeenGoodEdge.add(new ArrayList());
            for (int j = 0; j < dscc.size(); ++j) {
                Pair sucs = pSucc.apply(dscc.get(j).fst());
                dscc.set(j, dscc.get(j).mapFst(s -> (BitSet)sucs.fst()));
                this.dSccSeenGoodEdge.get(i).add(!((BitSet)sucs.snd()).isEmpty());
            }
        }
        NbaDetStateFactory.mapSlicesInplace(this.mSccs, s -> this.succAndSplit((RankedSlice)s, (Function<BitSet, Pair<BitSet, BitSet>>)pSucc, rankgen));
    }

    void leftNormalize() {
        this.aSccs.ifPresent(bitSetIntegerPair -> this.aSccsBuffer.andNot((BitSet)bitSetIntegerPair.fst()));
        NbaDetStateFactory.mapSlicesInplace(this.dSccs, RankedSlice::leftNormalized);
        NbaDetStateFactory.mapSlicesInplace(this.mSccs, RankedSlice::leftNormalized);
    }

    void pruneSimStates(NbaDetConf<S> conf) {
        if (!conf.extMask().isEmpty()) {
            Function<BitSet, BitSet> andPowerset = s -> BitSet2.intersection(s, this.powerSet);
            this.rSccs.and(this.powerSet);
            this.aSccsBuffer.and(this.powerSet);
            this.aSccs = this.aSccs.map(p -> p.mapFst(andPowerset));
            NbaDetStateFactory.mapSlicesInplace(this.dSccs, slice -> slice.map(p -> p.mapFst(andPowerset)));
            NbaDetStateFactory.mapSlicesInplace(this.mSccs, slice -> slice.map(p -> p.mapFst(andPowerset)));
        }
        if (!conf.intMask().isEmpty()) {
            NbaDetStateFactory.mapSlicesInplace(this.dSccs, sl -> sl.prunedWithSim(conf.intMask()));
            NbaDetStateFactory.mapSlicesInplace(this.mSccs, sl -> sl.prunedWithSim(conf.intMask()));
            BitSet newPS = new BitSet();
            newPS.or(this.rSccs);
            newPS.or(this.aSccsBuffer);
            newPS.or(this.aSccs.orElse(Pair.of(new BitSet(), 0)).fst());
            for (RankedSlice sl2 : this.dSccs) {
                for (Pair<BitSet, Integer> p2 : sl2.slice()) {
                    newPS.or(p2.fst());
                }
            }
            for (RankedSlice sl2 : this.mSccs) {
                for (Pair<BitSet, Integer> p2 : sl2.slice()) {
                    newPS.or(p2.fst());
                }
            }
            this.powerSet = newPS;
        }
    }

    private void relocateSwitchers(BitSet src, BitSet allowed, BitSet target) {
        target.or(BitSet2.without(src, allowed));
        src.and(allowed);
    }

    public BitSet extractSwitcherStates(NbaDetConf<S> c) {
        int i;
        BitSet switchers = new BitSet();
        this.relocateSwitchers(this.rSccs, c.sets().rsccStates(), switchers);
        this.relocateSwitchers(this.aSccsBuffer, c.sets().asccStates(), switchers);
        this.aSccs.ifPresent(bitSetIntegerPair -> this.relocateSwitchers((BitSet)bitSetIntegerPair.fst(), c.sets().asccStates(), switchers));
        for (i = 0; i < this.dSccs.size(); ++i) {
            for (Pair<BitSet, Integer> p : this.dSccs.get(i).slice()) {
                this.relocateSwitchers(p.fst(), c.sets().dsccsStates().get(i), switchers);
            }
        }
        for (i = 0; i < this.mSccs.size(); ++i) {
            for (Pair<BitSet, Integer> p : this.mSccs.get(i).slice()) {
                this.relocateSwitchers(p.fst(), c.sets().msccsStates().get(i), switchers);
            }
        }
        return switchers;
    }

    int performActions(NbaDetConf<S> c, BitSet prevAScc, RankGen rankgen) {
        int i;
        AtomicInteger domprio = new AtomicInteger(NbaDetState.weakestBadPrio(c));
        BiFunction<Pair, Boolean, Pair> fire = (p, good) -> {
            domprio.setPlain(Math.min(domprio.getPlain(), NbaDetState.rankToPriority((Integer)p.snd(), good)));
            return good != false ? p.mapSnd(Function.identity()) : p.mapSnd(rank -> rankgen.fresh());
        };
        int offset = -1;
        if (c.args().sepAccCyc()) {
            for (int i2 = 0; i2 < c.sets().asccsStates().size(); ++i2) {
                if (!prevAScc.intersects(c.sets().asccsStates().get(i2))) continue;
                offset = i2;
                break;
            }
            if (offset > -1 && this.aSccs.isPresent()) {
                BitSet curAScc = c.sets().asccsStates().get(offset);
                this.aSccsBuffer.or(BitSet2.without(this.aSccs.get().fst(), curAScc));
                this.aSccs.get().fst().and(curAScc);
            }
        }
        boolean aSccAlive = this.aSccs.isPresent() && !this.aSccs.get().fst().isEmpty();
        this.aSccs = this.aSccs.map(p -> (Pair)fire.apply((Pair)p, aSccAlive));
        if (c.args().sepAcc() && logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "ASCC " + (aSccAlive ? "alive" : "breakpoint"));
        }
        if (!aSccAlive && !this.aSccsBuffer.isEmpty()) {
            Pair<BitSet, Integer> curAscc = this.aSccs.orElse(Pair.of(new BitSet(), rankgen.fresh()));
            if (c.args().sepAccCyc()) {
                for (i = 0; i < c.sets().asccsStates().size(); ++i) {
                    int candIndex = (offset + i + 1) % c.sets().asccsStates().size();
                    BitSet cand = BitSet2.intersection(this.aSccsBuffer, c.sets().asccsStates().get(candIndex));
                    if (cand.isEmpty()) continue;
                    this.aSccs = Optional.of(curAscc.mapFst(bs -> cand));
                    this.aSccsBuffer.andNot(cand);
                    break;
                }
            } else {
                this.aSccs = Optional.of(curAscc.mapFst(bs -> (BitSet)this.aSccsBuffer.clone()));
                this.aSccsBuffer.clear();
            }
        }
        StringBuilder sb = new StringBuilder();
        if (c.args().sepDet()) {
            if (logger.getLevel().equals(Level.FINEST)) {
                logger.log(Level.FINEST, "scanning DSCCs");
            }
            for (i = 0; i < this.dSccs.size(); ++i) {
                RankedSlice dscc = this.dSccs.get(i);
                for (int j = 0; j < dscc.slice().size(); ++j) {
                    Pair<BitSet, Integer> el = dscc.slice().get(j);
                    if (el.fst().isEmpty()) {
                        sb.append(el.snd()).append(": dead ");
                        dscc.slice().set(j, fire.apply(el, false));
                        continue;
                    }
                    if (this.dSccSeenGoodEdge.get(i).get(j).booleanValue()) {
                        sb.append(el.snd()).append(": strd ");
                        dscc.slice().set(j, fire.apply(el, true));
                        continue;
                    }
                    sb.append(el.snd()).append(": neut ");
                }
            }
        }
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "scanning MSCCs");
        }
        for (RankedSlice mscc : this.mSccs) {
            if (mscc.slice().isEmpty()) continue;
            Pair<ArrayList<Integer>, ArrayList<Integer>> ret = mscc.getTreeRelations();
            ArrayList<Integer> p2 = ret.fst();
            ArrayList<Integer> l = ret.snd();
            if (logger.getLevel().equals(Level.FINEST)) {
                logger.log(Level.FINEST, "\nP: " + p2 + "\nL: " + l);
            }
            ArrayList<Boolean> nodeEmpty = new ArrayList<Boolean>(Collections.nCopies(mscc.slice().size(), true));
            ArrayList<Boolean> nodeSaturated = new ArrayList<Boolean>(Collections.nCopies(mscc.slice().size(), false));
            ArrayList<Integer> rightmostNeChild = new ArrayList<Integer>(Collections.nCopies(mscc.slice().size(), -1));
            for (int i3 = 0; i3 < mscc.slice().size(); ++i3) {
                sb.append(mscc.slice().get(i3).snd()).append(": ");
                boolean curEmpty = mscc.slice().get(i3).fst().isEmpty();
                if (!(curEmpty && nodeEmpty.get(i3).booleanValue() || p2.get(i3) == -1)) {
                    nodeEmpty.set(p2.get(i3), false);
                }
                if (curEmpty && !nodeEmpty.get(i3).booleanValue()) {
                    nodeSaturated.set(i3, true);
                }
                if (curEmpty) {
                    if (nodeSaturated.get(i3).booleanValue()) {
                        fire.apply(mscc.slice().get(i3), true);
                        sb.append("strd ");
                        if (c.args().mergeMode() == NbaDetConf.UpdateMode.MUELLER_SCHUPP) {
                            Pair<BitSet, Integer> curPair = mscc.slice().get(i3);
                            Pair<BitSet, Integer> rnePair = mscc.slice().get(rightmostNeChild.get(i3));
                            curPair.fst().or(rnePair.fst());
                            rnePair.fst().clear();
                        } else if (c.args().mergeMode() == NbaDetConf.UpdateMode.SAFRA) {
                            BitSet subtree = new BitSet();
                            for (int j = l.get(i3) + 1; j < i3; ++j) {
                                subtree.or(mscc.slice().get(j).fst());
                                mscc.slice().get(j).fst().clear();
                            }
                            mscc.slice().get(i3).fst().or(subtree);
                        }
                    } else {
                        sb.append("dead ");
                        mscc.slice().set(i3, fire.apply(mscc.slice().get(i3), false));
                    }
                } else {
                    sb.append("neut ");
                }
                if (mscc.slice().get(i3).fst().isEmpty() || p2.get(i3).equals(-1)) continue;
                rightmostNeChild.set(p2.get(i3), i3);
            }
        }
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "Events: " + sb);
        }
        if (c.args().mergeMode() == NbaDetConf.UpdateMode.MAX_MERGE) {
            Pair<Integer, Boolean> domEvent = NbaDetState.priorityToRank(domprio.getPlain());
            sb.append("dominating event: ").append(domEvent).append(" \n");
            NbaDetStateFactory.mapSlicesInplace(this.dSccs, sl -> sl.fullMerge((Integer)domEvent.fst()));
            NbaDetStateFactory.mapSlicesInplace(this.mSccs, sl -> sl.fullMerge((Integer)domEvent.fst()));
        }
        return domprio.getPlain();
    }

    public void integrateSwitcherStates(NbaDetConf<S> c, BitSet switchers, RankGen rankgen) {
        int i;
        BitSet tmp = BitSet2.intersection(switchers, c.sets().rsccStates());
        if (!tmp.isEmpty()) {
            this.rSccs.or(tmp);
        }
        if (!(tmp = BitSet2.intersection(switchers, c.sets().asccStates())).isEmpty()) {
            this.aSccsBuffer.or(tmp);
        }
        for (i = 0; i < this.dSccs.size(); ++i) {
            tmp = BitSet2.intersection(switchers, c.sets().dsccsStates().get(i));
            if (tmp.isEmpty()) continue;
            this.dSccs.get(i).slice().add(Pair.of(tmp, rankgen.fresh()));
        }
        for (i = 0; i < this.mSccs.size(); ++i) {
            tmp = BitSet2.intersection(switchers, c.sets().msccsStates().get(i));
            if (tmp.isEmpty()) continue;
            this.mSccs.get(i).slice().add(Pair.of(tmp, rankgen.fresh()));
        }
    }

    public void removeEmptySets() {
        if (this.aSccs.isPresent() && this.aSccs.get().fst().isEmpty()) {
            this.aSccs = Optional.empty();
        }
        NbaDetStateFactory.mapSlicesInplace(this.dSccs, RankedSlice::withoutEmptySets);
        NbaDetStateFactory.mapSlicesInplace(this.mSccs, RankedSlice::withoutEmptySets);
    }

    public void normalizeRanks() {
        ArrayList<Integer> used = new ArrayList<Integer>();
        this.aSccs.ifPresent(bitSetIntegerPair -> used.add((Integer)bitSetIntegerPair.snd()));
        for (RankedSlice sl2 : this.dSccs) {
            for (Pair<BitSet, Integer> p2 : sl2.slice()) {
                used.add(p2.snd());
            }
        }
        for (RankedSlice sl2 : this.mSccs) {
            for (Pair<BitSet, Integer> p2 : sl2.slice()) {
                used.add(p2.snd());
            }
        }
        Collections.sort(used);
        HashMap<Integer, Integer> rankMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < used.size(); ++i) {
            rankMap.put((Integer)used.get(i), i);
        }
        this.aSccs = this.aSccs.map(p -> p.mapSnd(rankMap::get));
        NbaDetStateFactory.mapSlicesInplace(this.dSccs, sl -> sl.map(p -> p.mapSnd(rankMap::get)));
        NbaDetStateFactory.mapSlicesInplace(this.mSccs, sl -> sl.map(p -> p.mapSnd(rankMap::get)));
    }

    public static <S> Edge<NbaDetState<S>> successor(NbaDetState<S> st, NbaDetConf<S> conf, BitSet val) {
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "begin " + BitSet2.toInt(val) + " succ of: " + st);
        }
        NbaDetStateFactory<S> ret = NbaDetStateFactory.of(st);
        RankGen rg = RankGen.from(NbaDetState.rankUpperBound(conf) + 1);
        ret.applySucc(conf, val, rg);
        if (ret.powerSet.isEmpty()) {
            if (logger.getLevel().equals(Level.FINEST)) {
                logger.log(Level.FINEST, "empty set reached\n----");
            }
            return Edge.of(NbaDetState.of(conf, new BitSet()), 1);
        }
        if (ret.powerSet.intersects(conf.accSinks())) {
            if (logger.getLevel().equals(Level.FINEST)) {
                logger.log(Level.FINEST, "accepting sink reached\n----");
            }
            return Edge.of(NbaDetState.of(conf, conf.accSinks()), 0);
        }
        ret.leftNormalize();
        if (conf.args().simInt() || conf.args().simExt()) {
            ret.pruneSimStates(conf);
        }
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "step+prune: " + ret.freeze());
        }
        BitSet switchers = ret.extractSwitcherStates(conf);
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "-switchers: " + ret.freeze());
        }
        int domPrio = ret.performActions(conf, st.aSccs().orElse(Pair.of(new BitSet(), 0)).fst(), rg);
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "merge: " + ret.freeze());
        }
        ret.integrateSwitcherStates(conf, switchers, rg);
        ret.leftNormalize();
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "+switchers: " + ret.freeze());
        }
        ret.removeEmptySets();
        ret.normalizeRanks();
        if (logger.getLevel().equals(Level.FINEST)) {
            logger.log(Level.FINEST, "normalize: " + ret.freeze() + " / " + domPrio + "\n----");
        }
        return Edge.of(ret.freeze(), domPrio);
    }

    static final class RankGen {
        private int next;

        private RankGen(int init) {
            this.next = init;
        }

        public static RankGen from(int init) {
            return new RankGen(init);
        }

        public int fresh() {
            int tmp = this.next++;
            return tmp;
        }
    }
}

