/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.Arrays;
import owl.bdd.BddSet;
import owl.translations.rabinizer.RabinizerState;

final class RabinizerProductEdge {
    private static final BddSet[] EMPTY = new BddSet[0];
    private final RabinizerState successorState;
    private BddSet[] successorAcceptance = EMPTY;

    RabinizerProductEdge(RabinizerState successorState) {
        this.successorState = successorState;
    }

    void addAcceptance(BddSet valuations, int acceptance) {
        if (this.successorAcceptance.length <= acceptance) {
            this.successorAcceptance = Arrays.copyOf(this.successorAcceptance, acceptance + 1);
        }
        this.successorAcceptance[acceptance] = this.successorAcceptance[acceptance] == null ? valuations : valuations.union(this.successorAcceptance[acceptance]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RabinizerProductEdge)) {
            return false;
        }
        RabinizerProductEdge cache = (RabinizerProductEdge)o;
        return this.successorState.equals(cache.successorState);
    }

    public RabinizerState getRabinizerSuccessor() {
        return this.successorState;
    }

    BddSet[] getSuccessorAcceptance() {
        return this.successorAcceptance;
    }

    public int hashCode() {
        return this.successorState.hashCode();
    }

    public String toString() {
        return this.successorState.toString();
    }
}

