/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;

public final class ParallelEvaluation {
    private ParallelEvaluation() {
    }

    public static <T> List<T> evaluate(List<? extends Supplier<Optional<T>>> suppliers) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList<Future<Optional>> futures = new ArrayList<Future<Optional>>();
        int s = suppliers.size();
        for (int i = 1; i < s; ++i) {
            futures.add(executorService.submit(((Supplier<Optional<T>>)suppliers.get(i))::get));
        }
        ArrayList results = new ArrayList();
        suppliers.get(0).get().ifPresent(results::add);
        for (Future future : futures) {
            try {
                ((Optional)Uninterruptibles.getUninterruptibly((Future)future)).ifPresent(results::add);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        executorService.shutdownNow();
        return results;
    }

    public static <A extends EmersonLeiAcceptance> Automaton<?, A> takeSmallest(List<? extends Automaton<?, A>> automata) {
        if (automata.isEmpty()) {
            throw new NoSuchElementException();
        }
        Automaton<?, A> smallestAutomaton = automata.get(0);
        int smallestSize = smallestAutomaton.states().size();
        int smallestAcceptanceSets = ((EmersonLeiAcceptance)smallestAutomaton.acceptance()).acceptanceSets();
        for (Automaton<?, A> automaton : automata.subList(1, automata.size())) {
            int automatonSize = automaton.states().size();
            int automatonAcceptanceSize = ((EmersonLeiAcceptance)automaton.acceptance()).acceptanceSets();
            if (smallestSize < automatonSize || smallestSize == automatonSize && smallestAcceptanceSets <= automatonAcceptanceSize) continue;
            smallestAutomaton = automaton;
            smallestSize = automatonSize;
            smallestAcceptanceSets = automatonAcceptanceSize;
        }
        return smallestAutomaton;
    }

    public static <A extends EmersonLeiAcceptance> Automaton<?, ? extends A> takeSmallestWildcardStateType(List<? extends Automaton<?, ? extends A>> automata) {
        return ParallelEvaluation.takeSmallest(automata);
    }
}

