/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sourceforge.plantuml.AFile;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.AParentFolderZip;

public class AFileZipEntry
implements AFile {
    private final File zipFile;
    private final String entry;

    public AFileZipEntry(File file, String entry) {
        this.zipFile = file;
        this.entry = entry;
    }

    public String toString() {
        return "AFileZipEntry::" + this.zipFile + " " + this.entry;
    }

    @Override
    public InputStream open() throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(this.zipFile));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            if (!ze.isDirectory() && fileName.trim().equalsIgnoreCase(this.entry.trim())) {
                return zis;
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOk() {
        if (this.zipFile.exists() && !this.zipFile.isDirectory()) {
            InputStream is = null;
            try {
                is = this.open();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.zipFile.hashCode() + this.entry.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AFileZipEntry)) {
            return false;
        }
        AFileZipEntry other = (AFileZipEntry)obj;
        return this.zipFile.equals(other.zipFile) && this.entry.equals(other.entry);
    }

    @Override
    public AParentFolder getParentFile() {
        return new AParentFolderZip(this.zipFile, this.entry);
    }

    @Override
    public String getAbsolutePath() {
        return this.zipFile.getAbsolutePath() + "~" + this.entry;
    }

    @Override
    public File getUnderlyingFile() {
        return this.zipFile;
    }
}

