/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileWithNoteOpale
extends AbstractFtile
implements Stencil {
    private final Ftile tile;
    private final Opale opale;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlaneNote != null) {
            HashSet<Swimlane> result = new HashSet<Swimlane>(this.tile.getSwimlanes());
            result.add(this.swimlaneNote);
            return Collections.unmodifiableSet(result);
        }
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    public static Ftile create(Ftile tile, Collection<PositionedNote> notes, ISkinParam skinParam, boolean withLink) {
        if (notes.size() > 1) {
            return new FtileWithNotes(tile, notes, skinParam);
        }
        if (notes.size() == 0) {
            throw new IllegalArgumentException();
        }
        return new FtileWithNoteOpale(tile, notes.iterator().next(), skinParam, withLink);
    }

    private FtileWithNoteOpale(Ftile tile, PositionedNote note, ISkinParam skinParam, boolean withLink) {
        super(tile.skinParam());
        this.swimlaneNote = note.getSwimlaneNote();
        if (note.getColors() != null) {
            skinParam = note.getColors().mute(skinParam);
        }
        this.tile = tile;
        this.notePosition = note.getNotePosition();
        if (note.getType() == NoteType.FLOATING_NOTE) {
            withLink = false;
        }
        Rose rose = new Rose();
        HtmlColor noteBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
        HtmlColor borderColor = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
        FontConfiguration fc = new FontConfiguration(skinParam, FontParam.NOTE, null);
        HorizontalAlignment align = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false);
        Sheet sheet = new CreoleParser(fc, align, skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, skinParam.wrapWidth(), skinParam.getPadding()), this, new UStroke(1.0));
        this.opale = new Opale(borderColor, noteBackgroundColor, text, skinParam.shadowing(null), withLink);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double yForFtile = (dimTotal.getHeight() - ((Dimension2D)dimTile).getHeight()) / 2.0;
        double marge = this.notePosition == NotePosition.LEFT ? dimNote.getWidth() + 20.0 : 0.0;
        return new UTranslate(marge, yForFtile);
    }

    private UTranslate getTranslateForOpale(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        double yForNote = (((Dimension2D)dimTotal).getHeight() - dimNote.getHeight()) / 2.0;
        if (this.notePosition == NotePosition.LEFT) {
            return new UTranslate(0.0, yForNote);
        }
        double dx = ((Dimension2D)dimTotal).getWidth() - dimNote.getWidth();
        return new UTranslate(dx, yForNote);
    }

    @Override
    public void drawU(UGraphic ug) {
        Swimlane intoSw = ug instanceof UGraphicInterceptorOneSwimlane ? ((UGraphicInterceptorOneSwimlane)ug).getSwimlane() : null;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        if (this.notePosition == NotePosition.LEFT) {
            Direction strategy = Direction.RIGHT;
            Point2D.Double pp1 = new Point2D.Double(dimNote.getWidth(), dimNote.getHeight() / 2.0);
            Point2D.Double pp2 = new Point2D.Double(dimNote.getWidth() + 20.0, dimNote.getHeight() / 2.0);
            this.opale.setOpale(strategy, pp1, pp2);
        } else {
            Direction strategy = Direction.LEFT;
            Point2D.Double pp1 = new Point2D.Double(0.0, dimNote.getHeight() / 2.0);
            Point2D.Double pp2 = new Point2D.Double(-20.0, dimNote.getHeight() / 2.0);
            this.opale.setOpale(strategy, pp1, pp2);
        }
        if (this.swimlaneNote == null || intoSw == this.swimlaneNote) {
            this.opale.drawU(ug.apply(this.getTranslateForOpale(ug)));
        }
        ug.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        UTranslate translate = this.getTranslate(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy(), orig.getOutY() + translate.getDy());
        }
        return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double height = Math.max(dimNote.getHeight(), ((Dimension2D)dimTile).getHeight());
        return new Dimension2DDouble(((Dimension2D)dimTile).getWidth() + 1.0 * dimNote.getWidth() + 20.0, height);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

