/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.style.PName;

public class CommandMultilinesFooter
extends CommandMultilines<TitledDiagram> {
    public CommandMultilinesFooter() {
        super("(?i)^(?:(left|right|center)?[%s]*)footer$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?footer$";
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines) {
        lines = lines.trim(false);
        Matcher2 m = this.getStartingPattern().matcher(lines.getFirst499().getTrimmed().getString());
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String align = m.group(1);
        Display strings = (lines = lines.subExtract(1, 1)).toDisplay();
        if (strings.size() > 0) {
            HorizontalAlignment defaultAlign = HorizontalAlignment.CENTER;
            if (SkinParam.USE_STYLES()) {
                defaultAlign = FontParam.FOOTER.getStyleDefinition().getMergedStyle(((UmlDiagram)diagram).getSkinParam().getCurrentStyleBuilder()).value(PName.HorizontalAlignment).asHorizontalAlignment();
            }
            diagram.getFooter().putDisplay(strings, HorizontalAlignment.fromString(align, defaultAlign));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty footer");
    }
}

