/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteImage;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteSvg;

public class CommandSpriteFile
extends SingleLineCommand2<UmlDiagram> {
    public CommandSpriteFile() {
        super(CommandSpriteFile.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpriteFile.class.getName(), RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("FILE", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram system, LineLocation location, RegexResult arg) {
        Sprite sprite;
        String src = arg.get("FILE", 0);
        try {
            if (src.startsWith("jar:")) {
                String inner = src.substring(4) + ".png";
                InputStream is = SpriteImage.getInternalSprite(inner);
                if (is == null) {
                    return CommandExecutionResult.error("No such internal sprite: " + inner);
                }
                sprite = new SpriteImage(ImageIO.read(is));
            } else if (src.contains("~")) {
                int idx = src.lastIndexOf("~");
                File f = FileSystem.getInstance().getFile(src.substring(0, idx));
                if (!f.exists()) {
                    return CommandExecutionResult.error("File does not exist: " + src);
                }
                String name = src.substring(idx + 1);
                sprite = this.getImageFromZip(f, name);
                if (sprite == null) {
                    return CommandExecutionResult.error("No image " + name + " in " + FileWithSuffix.getFileName(f));
                }
            } else {
                File f = FileSystem.getInstance().getFile(src);
                if (!f.exists()) {
                    return CommandExecutionResult.error("File does not exist: " + src);
                }
                sprite = this.isSvg(f.getName()) ? new SpriteSvg(f) : new SpriteImage(FileUtils.ImageIO_read(f));
            }
        }
        catch (IOException e) {
            Log.error("Error reading " + src + " " + e);
            return CommandExecutionResult.error("Cannot read: " + src);
        }
        system.addSprite(arg.get("NAME", 0), sprite);
        return CommandExecutionResult.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sprite getImageFromZip(File f, String name) throws IOException {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(f));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                if (!ze.isDirectory() && fileName.equals(name)) {
                    if (this.isSvg(name)) {
                        SpriteSvg spriteSvg = new SpriteSvg(FileUtils.readSvg(zis));
                        return spriteSvg;
                    }
                    SpriteImage spriteImage = new SpriteImage(ImageIO.read(zis));
                    return spriteImage;
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.closeEntry();
                zis.close();
            }
        }
        return null;
    }

    private boolean isSvg(String name) {
        return name.toLowerCase().endsWith(".svg");
    }
}

