/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleDefinition;
import net.sourceforge.plantuml.style.WithStyle;

public abstract class Grouping
implements Event,
WithStyle {
    private final String title;
    private final GroupingType type;
    private final String comment;
    private final HtmlColor backColorElement;
    private final Style style;
    private final Style styleHeader;

    @Override
    public StyleDefinition getDefaultStyleDefinition() {
        return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.group);
    }

    private StyleDefinition getHeaderStyleDefinition() {
        return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.groupHeader);
    }

    @Override
    public Style[] getUsedStyles() {
        return new Style[]{this.style, this.styleHeader == null ? this.styleHeader : this.styleHeader.eventuallyOverride(PName.BackGroundColor, this.backColorElement)};
    }

    public Grouping(String title, String comment, GroupingType type, HtmlColor backColorElement, StyleBuilder styleBuilder) {
        this.title = title;
        this.comment = comment;
        this.type = type;
        this.backColorElement = backColorElement;
        this.style = this.getDefaultStyleDefinition().getMergedStyle(styleBuilder);
        this.styleHeader = this.getHeaderStyleDefinition().getMergedStyle(styleBuilder);
    }

    public final String toString() {
        return super.toString() + " " + (Object)((Object)this.type) + " " + this.title;
    }

    public final String getTitle() {
        return this.title;
    }

    public final GroupingType getType() {
        return this.type;
    }

    public abstract int getLevel();

    public abstract HtmlColor getBackColorGeneral();

    public final String getComment() {
        return this.comment;
    }

    public final HtmlColor getBackColorElement() {
        return this.backColorElement;
    }

    @Override
    public abstract boolean isParallel();
}

