/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleDefinition;
import net.sourceforge.plantuml.style.Styleable;

public enum ParticipantType implements Styleable
{
    PARTICIPANT(ColorParam.participantBackground),
    ACTOR(ColorParam.actorBackground),
    BOUNDARY(ColorParam.boundaryBackground),
    CONTROL(ColorParam.controlBackground),
    ENTITY(ColorParam.entityBackground),
    QUEUE(ColorParam.queueBackground),
    DATABASE(ColorParam.databaseBackground),
    COLLECTIONS(ColorParam.collectionsBackground);

    private final ColorParam background;

    private ParticipantType(ColorParam background) {
        this.background = background;
    }

    public ColorParam getBackgroundColorParam() {
        return this.background;
    }

    @Override
    public StyleDefinition getDefaultStyleDefinition() {
        if (this == PARTICIPANT) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.participant);
        }
        if (this == ACTOR) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.actor);
        }
        if (this == BOUNDARY) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.boundary);
        }
        if (this == CONTROL) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.control);
        }
        if (this == ENTITY) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.entity);
        }
        if (this == QUEUE) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.queue);
        }
        if (this == DATABASE) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.database);
        }
        if (this == COLLECTIONS) {
            return StyleDefinition.of(SName.root, SName.element, SName.sequenceDiagram, SName.collections);
        }
        return null;
    }
}

