/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleKind;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final Display display;
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final ISkinSimple spriteContainer;
    private final UFont font;
    private final HtmlColor fontColor;

    public AbstractTextualComponent(Style style, LineBreakStrategy maxMessageSize, CharSequence label, FontConfiguration font, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        this(style, style, maxMessageSize, Display.getWithNewlines(label == null ? "" : label.toString()), font, horizontalAlignment, marginX1, marginX2, marginY, spriteContainer, false, fontForStereotype, htmlColorForStereotype);
    }

    public AbstractTextualComponent(Style style, LineBreakStrategy maxMessageSize, Display display, FontConfiguration fc, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, boolean enhanced, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        this(style, style, maxMessageSize, display, fc, horizontalAlignment, marginX1, marginX2, marginY, spriteContainer, enhanced, fontForStereotype, htmlColorForStereotype);
    }

    public AbstractTextualComponent(Style style, Style stereo, LineBreakStrategy maxMessageSize, Display display, FontConfiguration fc, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, boolean enhanced, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        super(style);
        this.spriteContainer = spriteContainer;
        boolean keepStereotype = true;
        if (SkinParam.USE_STYLES()) {
            fc = style.getFontConfiguration(this.getIHtmlColorSet());
            this.font = style.getUFont();
            this.fontColor = style.value(PName.FontColor).asColor(this.getIHtmlColorSet());
            horizontalAlignment = style.value(PName.HorizontalAlignment).asHorizontalAlignment();
            fontForStereotype = stereo.getUFont();
            htmlColorForStereotype = stereo.value(PName.FontColor).asColor(this.getIHtmlColorSet());
            keepStereotype = style.getKind() == StyleKind.STEREOTYPE;
        } else {
            this.font = fc.getFont();
            this.fontColor = fc.getColor();
        }
        this.marginX1 = marginX1;
        this.marginX2 = marginX2;
        this.marginY = marginY;
        Display display2 = this.display = keepStereotype ? display : display.withoutStereotype();
        this.textBlock = this.display.size() == 1 && this.display.get(0).length() == 0 ? new TextBlockEmpty() : (enhanced ? new BodyEnhanced2(this.display, FontParam.NOTE, spriteContainer, horizontalAlignment, fc, maxMessageSize) : this.display.create(fc, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, fontForStereotype, htmlColorForStereotype));
    }

    protected IHtmlColorSet getIHtmlColorSet() {
        return ((ISkinParam)this.spriteContainer).getIHtmlColorSet();
    }

    protected TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getHeight() + (double)(2 * this.marginY);
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HtmlColor getFontColor() {
        return this.fontColor;
    }

    protected final ISkinSimple getISkinSimple() {
        return this.spriteContainer;
    }
}

