/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.ReallyAbstractPlayer;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TitleStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PlayerClock
extends ReallyAbstractPlayer
implements Player {
    private final int period;
    private final int pulse;
    private final double ymargin = 8.0;

    public PlayerClock(TitleStrategy titleStrategy, ISkinParam skinParam, TimingRuler ruler, int period, int pulse) {
        super(titleStrategy, "", skinParam, ruler);
        this.period = period;
        this.pulse = pulse;
    }

    @Override
    public double getHeight(StringBounder striWngBounder) {
        return 30.0;
    }

    private SymbolContext getContext() {
        return new SymbolContext(HtmlColorUtils.COL_D7E0F2, HtmlColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawFrameTitle(UGraphic ug) {
    }

    @Override
    public void drawContent(UGraphic ug) {
        ug = this.getContext().apply(ug);
        ULine vline = new ULine(0.0, this.getHeight(ug.getStringBounder()) - 16.0);
        int i = 0;
        double lastx = -1.7976931348623157E308;
        while (i < 1000) {
            double x = this.ruler.getPosInPixel(new BigDecimal(i * this.period));
            if (x > this.ruler.getWidth()) {
                return;
            }
            ++i;
            if (x > lastx) {
                double dx = x - lastx;
                ULine hline1 = new ULine(dx * this.getPulseCoef(), 0.0);
                ULine hline2 = new ULine(dx * (1.0 - this.getPulseCoef()), 0.0);
                ug.apply(new UTranslate(lastx, 8.0)).draw(vline);
                ug.apply(new UTranslate(lastx, 8.0)).draw(hline1);
                double x2 = lastx + dx * this.getPulseCoef();
                ug.apply(new UTranslate(x2, 8.0)).draw(vline);
                ug.apply(new UTranslate(x2, 8.0 + vline.getDY())).draw(hline2);
            }
            lastx = x;
        }
    }

    private double getPulseCoef() {
        if (this.pulse == 0) {
            return 0.5;
        }
        return 1.0 * (double)this.pulse / (double)this.period;
    }

    @Override
    public void drawLeftHeader(UGraphic ug) {
    }

    @Override
    public double getWidthHeader(StringBounder stringBounder) {
        return 0.0;
    }

    public final int getPeriod() {
        return this.period;
    }
}

